/** @type {import('next').NextConfig} */

const nextConfig = {
  images: {
    domains: ['portal.chatknot.com'], // Existing image domain config
  },
  
  productionBrowserSourceMaps: true,
  // Disable React strict mode if needed
  reactStrictMode: false,
  // Disable ESLint checks during builds and development
  eslint: {
    ignoreDuringBuilds: true,
  },

  // Custom Webpack config
  webpack: (config, { isServer }) => {
    // Add rule to handle audio files
    config.module.rules.push({
      test: /\.(mp3|wav|ogg)$/, // Add file extensions you want to support
      use: {
        loader: 'file-loader',
        options: {
          outputPath: 'static/sounds', // Output directory for sounds
          publicPath: '/_next/static/sounds', // Public path to access sounds
          name: '[name].[hash].[ext]', // Naming convention for the files
        },
      },
    });

    return config;
  },
};

export default nextConfig;
