import CryptoJS from 'crypto-js';
const isEncrypted = (data) => {
    return (
      typeof data === "object" &&
      data.hasOwnProperty("e") &&
      data.hasOwnProperty("iv")
    );
  };
  const SECRET_KEY = CryptoJS.SHA256(process.env.NEXT_PUBLIC_SECRET_KEY);
  
  
  export const decryptData = ({ e, iv }) => {
    try {
      const key = SECRET_KEY;
      const ivBytes = CryptoJS.enc.Base64.parse(iv);
      const encryptedBytes = CryptoJS.enc.Base64.parse(e);
  
      const decrypted = CryptoJS.AES.decrypt(
        { ciphertext: encryptedBytes },
        key,
        { iv: ivBytes, mode: CryptoJS.mode.CBC, padding: CryptoJS.pad.Pkcs7 }
      );
  
      const decryptedText = decrypted.toString(CryptoJS.enc.Utf8);
      if (!decryptedText) throw new Error("Decryption resulted in an empty string");
  
      return JSON.parse(decryptedText); // Parse JSON before returning
    } catch (error) {
      console.error("Decryption failed:", error.message);
      return null;
    }
  };
  