import { io } from 'socket.io-client';
import getDeviceId from '../hooks/useVisitorId';
import swal from 'sweetalert'; // Import SweetAlert

let socket;

export const initializeSocket = async (token,refreshToken) => {
  try {
    const device_Id = await getDeviceId();
    if (!socket) {
      socket = io(`${process.env.NEXT_PUBLIC_API_URL}`, {
        auth: { token, refreshToken,device_id: device_Id || 'default-device-id' },
        timeout: 10000, // Timeout duration
        reconnection: true, // Enable reconnection
        reconnectionAttempts: 50, // Retry a limited number of times
        reconnectionDelay: 1000, // 1-second delay between retries
        reconnectionDelayMax: 5000, // Max delay between retries (5 seconds)
      });

      socket.on('connect', () => {
        
      });

      socket.on('connect_error', (err) => {
        console.error("Connection error:", err.message);
        // showConnectionErrorAlert();
      });

      socket.on('disconnect', (reason) => {
        
        if (reason === 'ping timeout' || reason === 'transport close') {
          showConnectionLostAlert();
        }
      });

      socket.on('reconnect', () => {
        
        showReconnectionAlert();
      });
    }
  } catch (error) {
    console.error("Error initializing socket:", error);
    swal({
      title: "Initialization Error",
      text: "An error occurred while initializing the connection.",
      icon: "error",
      button: "Retry",
    }).then(() => {
      initializeSocket(token);
    });
  }
  return socket;
};

export const disconnectSocket = () => {
  if (socket) {
    socket.disconnect();
    socket = null;
  }
};

export const getSocket = () => socket;

// Function to show connection lost alert
function showConnectionLostAlert() {
  swal({
    title: "Lost Internet Connection",
    text: "It seems you've lost your internet connection. We are trying to reconnect. If the issue persists, please reload the page.",
    icon: "warning",
    buttons: {
      reload: {
        text: "Reload Page",
        value: "reload",
      },
      close: {
        text: "Close",
        value: "close",
        className: "close-btn-red", // Add custom class to Close button
      },
    },
    closeOnClickOutside: false,
    closeOnEsc: false,
  }).then((value) => {
    if (value === "reload") {
      window.location.reload();
    } else if (value === "close") {
      
    }
  });
}

// Add CSS for the red background of the "Close" button
 


// Function to show connection error alert
function showConnectionErrorAlert() {
  swal({
    title: "Connection Error",
    text: "Unable to connect to the server. Please check your internet connection.",
    icon: "error",
    buttons: {
      reload: {
        text: "Reload Page",
        value: "reload",
      },
    },
  }).then((value) => {
    if (value === "reload") {
      window.location.reload();
    }
  });
}

// Function to show reconnection alert
function showReconnectionAlert() {
  swal({
    title: "Connection Restored",
    text: "Your connection has been restored. Please reload the page to ensure everything is up to date.",
    icon: "success",
    buttons: {
      reload: {
        text: "Reload Page",
        value: "reload",
      },
    },
  }).then((value) => {
    if (value === "reload") {
      window.location.reload();
    }
  });
}
