'use client'
import { createSlice, createAsyncThunk } from '@reduxjs/toolkit';
import axios from 'axios';

 
import { getCookie, setCookie } from 'cookies-next';
import apiRequest from '../../InterceptorAxios/axios';

export const verifyUserRole = createAsyncThunk(
  'user/verifyUserRole',
  async (token, thunkAPI) => {
    try {
      // Try the initial request with the provided token
      // const response = await axios.post(
      //   `${process.env.NEXT_PUBLIC_API_URL}/api/auth/user-verify-role`,
      //   {},
      //   {
      //     headers: {
      //       Authorization: `Bearer ${token}`,
      //     },
      //   }
      // );
      const data = await apiRequest('/api/auth/user-verify-role','POST',{})
      return data;
    } catch (error) {
      // If the error is due to an invalid/expired token (typically 401)
      if (error.response?.status === 403) {
        

        // Assume that the refresh token is stored securely in localStorage or a secure cookie
        const refreshToken = getCookie('refreshToken') // Adjust storage mechanism as needed

        if (refreshToken) {
          try {
            // Make a request to refresh the token
            const refreshResponse = await axios.post(
              `${process.env.NEXT_PUBLIC_API_URL}/api/auth/refresh-token`,
              { refreshToken },
              {
                headers: {
                  'Content-Type': 'application/json',
                },
              }
            );

            // Assuming the new token is returned in the response
            const newToken = refreshResponse.data.token;

            // Save the new token (adjust storage method as needed)
            // localStorage.setItem('token', newToken);
            setCookie('refreshToken', data.refreshToken);
                // Update access and refresh tokens in cookies
        setCookie('token', data.accessToken);
            // Retry the original request with the new token
            const retryResponse = await axios.post(
              `${process.env.NEXT_PUBLIC_API_URL}/api/auth/user-verify-role`,
              {},
              {
                headers: {
                  Authorization: `Bearer ${newToken}`,
                },
              }
            );

            return retryResponse.data;
          } catch (refreshError) {
            console.error('Failed to refresh token:', refreshError);
            return thunkAPI.rejectWithValue({ message: 'Failed to refresh token' });
          }
        } else {
          console.error('No refresh token available');
          return thunkAPI.rejectWithValue({ message: 'No refresh token available' });
        }
      }

      // If it's some other error, reject with the error response data
      return thunkAPI.rejectWithValue(error.response?.data);
    }
  }
);


// Async thunk for logging in a user
export const loginUser = createAsyncThunk(
  'user/loginUser',
  async (credentials, thunkAPI) => {
    try {
      
      const {email,password} = credentials;
      
      
      const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}/api/auth/login`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ email, password }),
      });
      return response.data;
    } catch (error) {
      return thunkAPI.rejectWithValue(error.response.data);
    }
  }
);

// Slice
const userSlice = createSlice({
  name: 'user',
  initialState: {
    userInfo: {},
    status: 'idle', // idle | loading | succeeded | failed
    error: null,
  },
  reducers: {
    setUser: (state, action) => {
      state.userInfo = action.payload;
    },
    clearUser: (state) => {
      state.userInfo = {
        userId: null,
        role: null,
        companyId: null,
        message: '',
        roleVerified: false,
        name:null,
        pseudonym:null,
      };
      state.status = 'idle';
    },
  },
  extraReducers: (builder) => {
    builder
      .addCase(verifyUserRole.pending, (state) => {
        state.status = 'loading';
      })
      .addCase(verifyUserRole.fulfilled, (state, action) => {
        state.status = 'succeeded';
        state.userInfo = {
          ...action.payload,
          roleVerified: true,
        };
      })
      .addCase(verifyUserRole.rejected, (state, action) => {
        state.status = 'failed';
        state.error = action.payload;
      });

    builder
      .addCase(loginUser.pending, (state) => {
        state.status = 'loading';
      })
      .addCase(loginUser.fulfilled, (state, action) => {
        state.status = 'succeeded';
        state.userInfo = action.payload.user;
      })
      .addCase(loginUser.rejected, (state, action) => {
        state.status = 'failed';
        state.error = action.payload;
      });
  },
});

export const { setUser, clearUser } = userSlice.actions;

const userReducer = userSlice.reducer;
export default userReducer;
