import { createSlice, createAsyncThunk } from '@reduxjs/toolkit';
import axios from 'axios';
import allTones from "../../../(dashboard)/data/allTones.json";
import apiRequest from '../../InterceptorAxios/axios';

// Async thunk to fetch tones for a specific user
// export const fetchTones = createAsyncThunk(
//   'tones/fetchTones',
//   async (userId, thunkAPI) => {
//     try {
//       const response = await axios-get(
//         `${process.env.NEXT_PUBLIC_API_URL}/api/settings/tones/${userId}`
//       );
//       // Return the tones from the API response
//       return response.data;
//     } catch (error) {
//       return thunkAPI.rejectWithValue(error.response?.data || 'Failed to fetch tones');
//     }
//   }
// );
export const fetchTones = createAsyncThunk(
  'tones/fetchTones',
  async (userId, thunkAPI) => {
    try {
      const response = await apiRequest(
        `/api/settings/tones/${userId}`,
        'GET'
      );
    
      
      return response;
    } catch (error) {
      return thunkAPI.rejectWithValue(error.response?.data || 'Failed to fetch tones');
    }
  }
);

// Async thunk to save tones
// export const saveTones = createAsyncThunk(
//   'tones/saveTones',
//   async (tonesData, thunkAPI) => {
//     try {
//       const response = await axios-post(`${process.env.NEXT_PUBLIC_API_URL}/api/settings/tones`, tonesData);
//          
//       return response.data; // Return the saved tone data (if any)
//     } catch (error) {
//       return thunkAPI.rejectWithValue(error.response?.data || 'Failed to save tones');
//     }
//   }
// );
export const saveTones = createAsyncThunk(
  'tones/saveTones',
  async (tonesData, thunkAPI) => {
    try {
      const response = await apiRequest(
        '/api/settings/tones',
        'POST',
        tonesData
      );
      return response;
    } catch (error) {
      return thunkAPI.rejectWithValue(error.response?.data || 'Failed to save tones');
    }
  }
);
// Slice
const tonesSlice = createSlice({
  name: 'tones',
  initialState: {
    newVisitorTone: null, // Holds the new visitor tone object
    messageTone: null, // Holds the message tone object
    toneStatus: 'idle', // idle | loading | succeeded | failed
    error: null,
  },
  reducers: {
    setMessageTone(state, action) {
        
      state.messageTone = action.payload;
    },
    setNotificationTone(state, action) {
        
      state.newVisitorTone = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder
      .addCase(fetchTones.pending, (state) => {
        state.toneStatus = 'loading';
      })
      .addCase(fetchTones.fulfilled, (state, action) => {
        state.toneStatus = 'succeeded';
        state.newVisitorTone = allTones.find(tone => tone.name === action.payload.new_visitor_tone);
        state.messageTone = allTones.find(tone => tone.name === action.payload.message_tone);
      })
      .addCase(fetchTones.rejected, (state, action) => {
        state.toneStatus = 'failed';
        state.error = action.payload;
      })
      .addCase(saveTones.pending, (state) => {
        state.toneStatus = 'loading';
      })
      .addCase(saveTones.fulfilled, (state, action) => {
        state.toneStatus = 'succeeded';
        // Optionally update the Redux state with the saved tones if needed
        
      })
      .addCase(saveTones.rejected, (state, action) => {
        state.toneStatus = 'failed';
        state.error = action.payload;
      });
  },
});

// Export actions
export const { setMessageTone, setNotificationTone } = tonesSlice.actions;

export default tonesSlice.reducer;
