// selectedBrandsSlice.js
import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  selectedBrands: [],
};

const selectedBrandsSlice = createSlice({
  name: 'selectedBrands',
  initialState,
  reducers: {
    setSelectedBrands(state, action) {
      state.selectedBrands = action.payload;
    },
    addSelectedBrand(state, action) {
      if (!state.selectedBrands.includes(action.payload)) {
        state.selectedBrands.push(action.payload);
      }
    },
    removeSelectedBrand(state, action) {
      state.selectedBrands = state.selectedBrands.filter(
        (brand) => brand !== action.payload
      );
    },
    toggleBrandSelection(state, action) {
      const brand = action.payload;
      if (state.selectedBrands.includes(brand)) {
        state.selectedBrands = state.selectedBrands.filter(
          (item) => item !== brand
        );
      } else {
        state.selectedBrands.push(brand);
      }
    },
  },
});

export const {
  setSelectedBrands,
  addSelectedBrand,
  removeSelectedBrand,
  toggleBrandSelection,
} = selectedBrandsSlice.actions;

export default selectedBrandsSlice.reducer;
