// import necessary styles and components
import AddBootstrap from "./AddBootstrap.js";
import '@fortawesome/fontawesome-free/css/all.min.css';
import 'bootstrap/dist/css/bootstrap.min.css';
import './globals.css';
import StoreProvider from "./StoreProrvide.js";

export const metadata = {
  title: "Chatknot - Live Chat Software For Your Website",
  description: "Chatknot - Live Chat Software For Your Website",
};

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <head>
        {/* Favicon for general use */}
        <link rel="icon" href="/ico/favicon.ico" sizes="any" type="image/x-icon" />

        {/* Apple Touch Icons */}
        <link rel="apple-touch-icon" sizes="57x57" href="/ico/apple-icon-57x57.png" />
        <link rel="apple-touch-icon" sizes="60x60" href="/ico/apple-icon-60x60.png" />
        <link rel="apple-touch-icon" sizes="72x72" href="/ico/apple-icon-72x72.png" />
        <link rel="apple-touch-icon" sizes="76x76" href="/ico/apple-icon-76x76.png" />
        <link rel="apple-touch-icon" sizes="114x114" href="/ico/apple-icon-114x114.png" />
        <link rel="apple-touch-icon" sizes="120x120" href="/ico/apple-icon-120x120.png" />
        <link rel="apple-touch-icon" sizes="144x144" href="/ico/apple-icon-144x144.png" />
        <link rel="apple-touch-icon" sizes="152x152" href="/ico/apple-icon-152x152.png" />
        <link rel="apple-touch-icon" sizes="180x180" href="/ico/apple-icon-180x180.png" />

        {/* Android Icons */}
        <link rel="icon" type="image/png" sizes="36x36" href="/ico/android-icon-36x36.png" />
        <link rel="icon" type="image/png" sizes="48x48" href="/ico/android-icon-48x48.png" />
        <link rel="icon" type="image/png" sizes="72x72" href="/ico/android-icon-72x72.png" />
        <link rel="icon" type="image/png" sizes="96x96" href="/ico/android-icon-96x96.png" />
        <link rel="icon" type="image/png" sizes="144x144" href="/ico/android-icon-144x144.png" />
        <link rel="icon" type="image/png" sizes="192x192" href="/ico/android-icon-192x192.png" />

        {/* Microsoft Icons */}
        <meta name="msapplication-TileImage" content="/ico/ms-icon-70x70.png" />
        <meta name="msapplication-TileImage" content="/ico/ms-icon-144x144.png" />
        <meta name="msapplication-TileImage" content="/ico/ms-icon-150x150.png" />
        <meta name="msapplication-TileImage" content="/ico/ms-icon-310x310.png" />

        {/* Web App Manifest */}
        <link rel="manifest" href="/ico/manifest.json" />

        {/* Optional theme color for browsers */}
        <meta name="theme-color" content="#ffffff" />
        <meta name="msapplication-TileColor" content="#da532c" />
      </head>
      <body>
        <StoreProvider>
          {children}
        </StoreProvider>
      </body>
    </html>
  );
}
