// components/Sidebar.js
"use client";
import React, { useEffect, useState } from "react";
// import logo from '@/public/assets/images/dp.png';
import Link from "next/link";
 
import { usePathname } from "next/navigation";
import { useSelector } from "react-redux";
 
import logo from "@/public/assets/images/ck-logo-beta.png";
import { getSocket } from "@/app/lib/socketManager";
import apiRequest from "@/app/lib/InterceptorAxios/axios";
import { FaCircle } from "react-icons/fa";
import OnlineUsers from "./OnlineUsers";
import { CgWebsite } from "react-icons/cg";
import { decryptData } from "@/app/utils/DecryptData";



const Sidebar = () => {
  const pathname = usePathname();

  const isActive = (path) => pathname === path;
  const user = useSelector((state) => state.user.userInfo);
  const status = useSelector((state) => state.user.status);
  const [userRole, setuserRole] = useState();
  const [onlineUsers, setOnlineUsers] = useState([]);
  const [filteredUsers, setFilteredUsers] = useState([]);
  const [UnFilteredUsers, setUnFilteredUsers] = useState([])
  
  

  // Fetch users related to the company
  const fetchCompanyUsers = async (user_id) => {
    try {
      
        const response = await apiRequest(`/api/users/for_online_filter/${user_id}`);
     
         // Assuming the API returns users in 'data' field
        setUnFilteredUsers(response); // Assuming the API returns users in 'data' field
        return response; // Assuming the API returns users in 'data' field

       
    } catch (error) {
      console.error("Error fetching users:", error);
      return [];
    }
  };
 
  

  useEffect(() => {
    const socketinst = getSocket();
    if (!socketinst) return;
  
    socketinst.on("online_users", async (data) => {
      const decryptedData = decryptData(data)
      
      const usersFromSocket = decryptedData
      try {
                // Step 1: Fetch users related to the company using the API
        const usersFromApi = await fetchCompanyUsers(user.userId);
               if (usersFromApi && usersFromSocket && usersFromSocket.length > 0) {
          // Step 2: Filter out the users that don't match the ones from the socket
          const filtered = usersFromApi.filter((apiUser) =>
            usersFromSocket.some((socketUser) => parseInt(socketUser.userId) === apiUser.user_id)
          );
  
                  // Step 3: Update the filtered users state
          setFilteredUsers(filtered);
        } else {
          console.error("API or Socket data is missing or empty:" );
        }
      } catch (error) {
        console.error("Error processing online users:", error);
      }
    });
  
    socketinst.on("online_user", (data) => {
      const decryptedData = decryptData(data)
      const { userId } = decryptedData;
              // Ensure that the users are arrays before checking
      if (Array.isArray(UnFilteredUsers) && Array.isArray(filteredUsers)) {
        // Check if the received user exists in the Users state
        const userExists = UnFilteredUsers.some((user) => user.user_id === userId);
  
        if (userExists) {
                  // Check if the user is already in the FilteredUsers state
          const alreadyFiltered = filteredUsers.some(
            (filteredUser) => filteredUser.user_id === parseInt(userId)
          );
  
          if (!alreadyFiltered) {
            // Add the user to the FilteredUsers state
            setFilteredUsers((prevFilteredUsers) => [
              ...prevFilteredUsers,
              UnFilteredUsers.find((user) => user.user_id === parseInt(userId)),
            ]);
          } else {
                }
        } else {
          console.warn("User not found in Users state.");
        }
      } else {
        console.error("Users or FilteredUsers are not arrays:", {
          UnFilteredUsers,
          filteredUsers,
        });
      }
    });
   // Listen for the 'offline_admin' event to remove the user from filteredUsers
   socketinst.on("offline_admin", (data) => {
    const decryptedData = decryptData(data)
    const { userId } = decryptedData;
    //     //     // Remove the user from the filteredUsers state
    setFilteredUsers((prevFilteredUsers) =>
      prevFilteredUsers.filter((user) => user.user_id != userId)
  );
    });

  // Cleanup socket on component unmount
  return () => {
    socketinst.off("online_users");
    socketinst.off("online_user");
    socketinst.off("offline_admin");
  };
  }, [UnFilteredUsers, filteredUsers]); // Re-run this effect when UnFilteredUsers or filteredUsers change
  
  return (
    <div className="sidebar">
    <div className="user-info">
      <div className="left-container">
        <img
          src={logo.src}
          alt="ChatKnot"
          style={{ width: "150px", objectFit: "contain" }}
        />
        <div className="dropdown">
          <div className="dropdown-content">
            <div className="status-item online" data-status="Online">
              <span className="status-icon online"></span>
              <span className="status-text">Online</span>
            </div>
            <div className="status-item offline" data-status="Offline">
              <span className="status-icon offline"></span>
              <span className="status-text">Offline</span>
            </div>
            <div className="status-item away" data-status="Away">
              <span className="status-icon away"></span>
              <span className="status-text">Away</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  
    <ul className="nav flex-column">
          
      {user.role == 1 ? (
        <li className={`nav-item ${isActive("/company-management") ? "active" : ""}`}>
          <Link href="/company-management" prefetch={false}>
            <i className="fa fa-home"></i>Company Board
          </Link>
        </li>
      ) : (
        <li className={`nav-item ${isActive("/brands") ? "active" : ""}`}>
          <Link href="/brands" shallow prefetch={false}>
            <i className="fa fa-home"></i>Brands
          </Link>
        </li>
      )}
      {user.role == 1 && (
       <li className={`nav-item ${isActive("/all-brands") ? "active" : ""}`}>
       <Link href="/all-brands" shallow prefetch={false}>
       <i className="fa-solid fa-globe"></i>All Brands
       </Link>
     </li>
      ) }
      <li className={`nav-item ${isActive("/all-users") ? "active" : ""}`}>
        <Link href="/all-users" shallow prefetch={false}>
          <i className="fa-solid fa-user-group"></i>All Users
        </Link>
      </li>
  
      <li className={`nav-item ${isActive("/chat") ? "active" : ""}`}>
        <Link href="/chat" shallow prefetch={false}>
          <i className="fa fa-comments"></i>Chat
        </Link>
      </li>
  
      <li className={`nav-item ${isActive("/history") ? "active" : ""}`}>
        <Link href="/history" shallow prefetch={false}>
          <i className="fa fa-history"></i>History
        </Link>
      </li>
  
      <li className={`nav-item ${isActive("/profile") ? "active" : ""}`}>
        <Link href="/profile">
          <i className="fa fa-user"></i>Profile
        </Link>
      </li>
      <li className={`nav-item ${isActive("/settings") ? "active" : ""}`}>
        <Link href="/settings">
        <i className="fa fa-cog" aria-hidden="true"></i>
        Settings
        <span className="badge bg-danger">new</span>
        </Link>
      </li>
      {user.role == 1 && (
        <li className={`nav-item ${isActive("/alerts") ? "active" : ""}`}>
          <Link href="/alerts" prefetch={false}>
          <i className="fa-solid fa-bell"></i>Alerts
          </Link>
        </li>
      ) }
    </ul>
  
    {/* Displaying filtered and unfiltered users */}
  <hr />
    <OnlineUsers filteredUsers={filteredUsers} UnFilteredUsers={UnFilteredUsers}/>

  </div>
  
  );
};

export default Sidebar;

// components/Sidebar.js
// "use client";
// import React, { useState } from "react";
// // import logo from '@/public/assets/images/dp.png';
// import Link from "next/link";
 
// import { usePathname } from "next/navigation";
// import { useSelector } from "react-redux";
 
// import logo from "@/public/assets/images/ck-logo-beta.png";

// const Sidebar = () => {
//   const pathname = usePathname();

//   const isActive = (path) => pathname === path;
//   const user = useSelector((state) => state.user.userInfo);
//   const status = useSelector((state) => state.user.status);
//   const [userRole, setuserRole] = useState();
 
//   return (
//     <div className="sidebar">
//       <div className="user-info">
//         <div className="left-container">
//           {/* <Image src={logo} width={500} height={500} alt="Picture of the author" /> */}
//         </div>
//         <div className="left-container">
//           {/* <h5>{user.pseudonym}</h5> */}
//           <img
//             src={logo.src}
//             alt="ChatKnot"
//             style={{ width: "150px", objectFit: "contain" }}
//           />
//           <div className="dropdown">
//             {/* <button className="dropdown-btn">
//               <span className="status-icon online"></span> <span id="status-text">Online</span>
//             </button> */}
//             <div className="dropdown-content">
//               <div className="status-item online" data-status="Online">
//                 <span className="status-icon online"></span>
//                 <span className="status-text">Online</span>
//               </div>
//               <div className="status-item offline" data-status="Offline">
//                 <span className="status-icon offline"></span>
//                 <span className="status-text">Offline</span>
//               </div>
//               <div className="status-item away" data-status="Away">
//                 <span className="status-icon away"></span>
//                 <span className="status-text">Away</span>
//               </div>
//             </div>
//           </div>
//         </div>
//       </div>
//       <ul className="nav flex-column">
//         {}        
//         {user.role == 1 ? (
//           <li
//             className={`nav-item ${
//               isActive("/company-management") ? "active" : ""
//             }`}
//           >
//             <Link href="/company-management" prefetch={false}>
//               <i className="fa fa-home"></i>Company Board
//             </Link>
//           </li>
//         ) : (
//           <li className={`nav-item ${isActive("/brands") ? "active" : ""}`}>
//             <Link href="/brands" shallow prefetch={false}>
//               <i className="fa fa-home"></i>Brands
//             </Link>
//           </li>
//         )}

//         <li className={`nav-item ${isActive("/all-users") ? "active" : ""}`}>
//           <Link href="/all-users" shallow prefetch={false}>
//             <i className="fa-solid fa-user-group"></i>All Users
//           </Link>
//         </li>
//         {/* <li className={`nav-item ${isActive('/') ? 'active' : ''}`}>
//           <Link href="/" prefetch={false}>
//             <i className="fa fa-home"></i> Home
//           </Link>
//         </li> */}
//         <li className={`nav-item ${isActive("/chat") ? "active" : ""}`}>
//           <Link href="/chat" shallow prefetch={false}>
//             <i className="fa fa-comments"></i>Chat
//           </Link>
//         </li>

//         <li className={`nav-item ${isActive("/history") ? "active" : ""}`}>
//           <Link href="/history" shallow prefetch={false}>
//             <i className="fa fa-history"></i>History
//           </Link>
//         </li>
//         {/* <li className={`nav-item ${isActive('/analytics') ? 'active' : ''}`}>
//           <Link href="/analytics">
//             <i className="fa fa-line-chart"></i> Analytics
//           </Link>
//         </li> */}
//         {/* <li className={`nav-item ${isActive('/settings') ? 'active' : ''}`}>
//           <Link href="/settings">
//             <i className="fa fa-cog"></i> Settings
//           </Link>
//         </li> */}
//         {/* <li className={`nav-item ${isActive('/team') ? 'active' : ''}`}>
//           <Link href="/team">
//             <i className="fa fa-users"></i> Team
//           </Link>
//         </li> */}
//         <li className={`nav-item ${isActive("/profile") ? "active" : ""}`}>
//           <Link href="/profile">
//             <i className="fa fa-user"></i>Profile
//           </Link>
//         </li>
//       </ul>
//     </div>
//   );
// };

// export default Sidebar;
