import React, { useState } from "react";
import { FaCircle } from "react-icons/fa";


const OnlineUsers = ({ filteredUsers, UnFilteredUsers }) => {
  const [isCollapsed, setIsCollapsed] = useState(false); // State to handle collapse

  return (
    <div className="users-list-container">
      {/* Heading with Collapse Button */}
      <h2 className="online-users-heading">
        ONLINE ({filteredUsers.length}){" "}
        <span
          className="collapse-button"
          onClick={() => setIsCollapsed(!isCollapsed)}
          style={{ cursor: "pointer" }}
        >
          {isCollapsed ? "+" : "-"}
        </span>
      </h2>

      {/* Users List Section */}
      <div
        className={`users-list ${isCollapsed ? "collapsed" : "expanded"}`} // Add animation classes
      >
        {/* Active Users */}
        {filteredUsers.length > 0 ? (
          filteredUsers.map((user) => (
            <div key={user.user_id} className="user-item active-users">
              <span>{user.name}</span>
              <FaCircle size={9} color="#34ac15" />
            </div>
          ))
        ) : (
          <div className="no-users">No online users</div>
        )}

        {/* Remaining Offline Users */}
        {UnFilteredUsers.length > 0 && (
          <div className="remaining-users">
            {UnFilteredUsers.filter(
              (unfilteredUser) =>
                !filteredUsers.some(
                  (filteredUser) => filteredUser.user_id === unfilteredUser.user_id
                )
            ).map((user) => (
              <div key={user.user_id} className="user-item offline-users">
                <span>{user.name}</span>
                <FaCircle size={9} color="#f54848" />
              </div>
            ))}
          </div>
        )}
      </div>
    </div>
  );
};

export default OnlineUsers;
