"use client"
import Link from 'next/link';
import React from 'react';
import '../../css/style.css';
import { useRouter } from 'next/navigation';
import {deleteCookie, getCookie} from 'cookies-next'; // Import js-cookie for handling cookies
import axios from 'axios'; // Import axios
import { disconnectSocket, getSocket } from '@/app/lib/socketManager';
import logo from '@/public/assets/images/ck-logo.png'
import { useDispatch, useSelector } from 'react-redux';
import { reset } from '@/app/lib/features/chat/chatSlice';

const Header = () => {
  const router = useRouter();
const dispatch = useDispatch()
const user = useSelector((state) => state.user.userInfo);
const { tabs, activeTab } = useSelector((state) => state.chat);
const socket = getSocket();
const handleLogout = async () => {
    try {
      if (activeTab) {
                        const active = tabs.find((tab) => tab.client_id === activeTab)
                socket.emit("stop typing admin", {
          chatKey: `${active?.public_key}_${active?.client_id}`,
          from: user?.pseudonym,
        });
      }
      // Call the logout API
      disconnectSocket();
      await axios.post(`${process.env.NEXT_PUBLIC_API_URL}/api/auth/logout`, {}, {
        headers: {
            Authorization: `Bearer ${getCookie('token')}`,
            'x-refresh-token': getCookie('refreshToken') // You can extract this refresh token from cookies
        }
    });
      dispatch(reset());
    } catch (error) {
      console.error('Error logging out:', error);
    } finally {
      deleteCookie('token');
      deleteCookie('refreshToken');
      // Redirect to the login page
      router.push('/login');
    }
  };

  return (
    <nav className="navbar navbar-light">
      <div className="container-fluid justify-content-justify header-dashboard no-padding">
        <div className="left-div">


          {/* <img src={logo.src} alt="ChatKnot" style={{width:'200px',objectFit:'contain'}} /> */}
        </div>
        <div className="right-div">
          {/* <Link prefetch={false} href="#" className="me-3 mt-2">
            <i className="fa fa-cog"></i>
          </Link> */}
        <a href="https://www.linkedin.com/company/chatknot/" className="supportus" target="_blank">
        <img src="https://tool.chatknot.com/static/scripts/linkedin2.png"/></a>
                <h5>{user.name} ( {user?.pseudonym} )</h5>
          <button href="#" className='me-3 mt-1 ms-auto   logout-btn' onClick={handleLogout}>
            <i className="fa fa-sign-out"></i>
          </button>
        </div>
      </div>
    </nav>
  );
};

export default Header;
