'use client';

import React, { useEffect, useState } from 'react';

const DeviceIdentifier = () => {
  const [visitorId, setVisitorId] = useState(null);

  useEffect(() => {
    const detectIncognitoMode = async () => {
      const fs = window.RequestFileSystem || window.webkitRequestFileSystem;
      if (!fs) {
        return false; // Incognito detection not supported
      }
      return new Promise((resolve) => {
        fs(window.TEMPORARY, 100, () => resolve(false), () => resolve(true));
      });
    };

    const generateFingerprint = async () => {
      const userAgent = navigator.userAgent;
      const language = navigator.language;
      const vendor = navigator.vendor;
      const platform = navigator.platform;
      const colorDepth = screen.colorDepth;
      const pixelDepth = screen.pixelDepth;
      const timezoneOffset = new Date().getTimezoneOffset();
      const plugins = Array.from(navigator.plugins)
        .map((plugin) => plugin.name)
        .join(',');

      // Canvas rendering
      const canvas = document.createElement('canvas');
      const ctx = canvas.getContext('2d');
      ctx.textBaseline = 'top';
      ctx.font = '16px Arial';
      ctx.fillStyle = 'blue';
      ctx.fillText(userAgent, 10, 50);
      const canvasFingerprint = canvas.toDataURL();

      // Combine all collected information
      const fingerprint = [
        userAgent,
        language,
        vendor,
        platform,
        colorDepth,
        pixelDepth,
        timezoneOffset,
        plugins,
        canvasFingerprint,
      ].join('::');

      return fingerprint;
    };

    const generateVisitorId = async () => {
      const storedId = localStorage.getItem('visitorId');
      if (storedId) {
        setVisitorId(storedId);
        return;
      }

      const fingerprint = await generateFingerprint();
      const isIncognito = await detectIncognitoMode();

      // Generate a unique random salt for each browser instance
      const randomSalt = Math.random().toString(36).substring(2, 15);

      // Hash the fingerprint and include the random salt
      const encoder = new TextEncoder();
      const data = encoder.encode(fingerprint + randomSalt);
      const hashBuffer = await crypto.subtle.digest('SHA-256', data);
      const hash = Array.from(new Uint8Array(hashBuffer))
        .map((byte) => byte.toString(16).padStart(2, '0'))
        .join('');
      const uniqueId = isIncognito ? `${hash}-incognito` : hash;

      // Save the ID to localStorage
      localStorage.setItem('visitorId', uniqueId);
      setVisitorId(uniqueId);
    };

    generateVisitorId();
  }, []);

  return (
    <div>
      <h1>Your Visitor ID</h1>
      {visitorId ? <p>{visitorId}</p> : <p>Generating ID...</p>}
    </div>
  );
};

export default DeviceIdentifier;

//user login to device 1
// login to device 2 : show alert you already login to other device do you want to continue here

