// components/ProfileUpdateModal.js
import React from 'react';
import { Modal, Button, Form } from 'react-bootstrap';

const ProfileUpdateModal = ({ onClose }) => {
  return (
    <Modal show onHide={onClose} centered>
      <Modal.Header closeButton>
        <Modal.Title>Update Profile</Modal.Title>
      </Modal.Header>
      <Modal.Body>
        <Form>
          <Form.Group className="mb-3" controlId="formName">
            <Form.Label>Real Name</Form.Label>
            <Form.Control type="text" placeholder="Enter real name" />
          </Form.Group>
          <Form.Group className="mb-3" controlId="formDesignation">
            <Form.Label>Designation</Form.Label>
            <Form.Control type="text" placeholder="Enter designation" />
          </Form.Group>
          <Form.Group className="mb-3" controlId="formpseudonym">
            <Form.Label>Pseudonym</Form.Label>
            <Form.Control type="text" placeholder="Enter Pseudonym" />
          </Form.Group>
          <Form.Group className="mb-3" controlId="formEmail">
            <Form.Label>Email</Form.Label>
            <Form.Control type="email" placeholder="Enter email" />
          </Form.Group>
        </Form>
      </Modal.Body>
      <Modal.Footer>
        <Button variant="secondary" onClick={onClose}>
          Cancel
        </Button>
        <Button variant="primary">Save Changes</Button>
      </Modal.Footer>
    </Modal>
  );
};

export default ProfileUpdateModal;
