"use client";
import { useState, useEffect, useCallback, useRef } from "react";
import { useSelector } from "react-redux";
import { countryNameToCode } from "@/app/countries";
import { getSocket } from "@/app/lib/socketManager";
import { FaCog, FaFilter, FaSearch } from "react-icons/fa";
import "react-date-range/dist/styles.css"; // main css file
import { Calendar } from "react-date-range";
import "react-date-range/dist/theme/default.css"; // theme css file
import SessionChat from "./SessionChat";
import { DateRangePicker } from "react-date-range";
import "react-date-range/dist/styles.css"; // main style file
import "react-date-range/dist/theme/default.css"; // theme css file
import debounce from "lodash.debounce";
import windows from "@/public/assets/images/windows.png";
import Ios from "@/public/assets/images/apple.png";
import chrome from "@/public/assets/images/chrome.png";
import edge from "@/public/assets/images/edge.png";
import firefox from "@/public/assets/images/firefox-icon.png";
import safari from "@/public/assets/images/safari-icon.png";
import ubunto from "@/public/assets/images/ubunto.png";
import android from "@/public/assets/images/android.png";
import LoadingSkeletonTable from "../loading";
import axios from "axios";
import { getCookie } from "cookies-next";
import { FaFilterCircleXmark } from "react-icons/fa6";
import apiRequest from "@/app/lib/InterceptorAxios/axios";
import { decryptData } from "@/app/utils/DecryptData";
const History = () => {
  const [visitors, setVisitors] = useState([]);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [currentPage, setCurrentPage] = useState(1);
  const [totalPages, setTotalPages] = useState(1);
  const limit = 50;
  const [socket, setSocket] = useState(null);
  const [hideColumns, setHideColumns] = useState(false);
  const user = useSelector((state) => state.user.userInfo);
  const [searchTerm, setSearchTerm] = useState(""); // New search term state
  const [chatSessionId, SetChatSessionId] = useState();
  const [NewHistoryRecieved, setNewHistoryRecieved] = useState([]);
  const [allVisitors, setAllVisitors] = useState([]);
  const [showDatePicker, setShowDatePicker] = useState(false);
  const [isFiltering, setisFiltering] = useState(false);
  const [totalRecords, setTotalRecords] = useState();
  const [includeName, setIncludeName] = useState(true);
  const [includeEmail, setIncludeEmail] = useState(true);
  const [includeClientId, setIncludeClientId] = useState(true);
  const [includeMsg, setincludeMsg] = useState(true);
  const [isDropdownOpen, setIsDropdownOpen] = useState(false);
  const [IsBrandChange, setIsBrandChange] = useState([]);
  const [brandSearch, setBrandSearch] = useState("");
  const [filterCurrentPage, setFilterCurrentPage] = useState(1);
  const [filterTotalPages, setFilterTotalPages] = useState(1);
  const [servedStatus, setservedStatus] = useState("all");
const [connectedStatus, setconnectedStatus] = useState("all");
  const token = getCookie("token");
  // const [selectedBrands, setSelectedBrands] = useState([]);
  const [filteredTotalRecords, setfilteredTotalRecords] = useState(0);
  const [tempDateRange, setTempDateRange] = useState([
    {
      startDate: new Date(),
      endDate: new Date(),
      key: "selection",
    },
  ]);

  const [showSettings, setShowSettings] = useState(false);
  const [selectedBrands, setSelectedBrands] = useState([]);
  const [brands, setBrands] = useState([]);
  const [filteredBrands, setFilteredBrand] = useState();

  const [dateRange, setDateRange] = useState(null);

  // const filteredBrands = allBrands.filter((brand) =>
  //   brand.toLowerCase().includes(brandSearch.toLowerCase())
  // );

  const handleSelect = (ranges) => {
    setTempDateRange([ranges.selection]); // Temporary selection until "Accept" is clicked
  };
  // Function to update IP health in the visitors state
  const updateIpHealth = (visitorSessionId, newIpHealth) => {
    setVisitors((prevVisitors) =>
      prevVisitors.map((visitor) =>
        visitor.visitor_session_id === visitorSessionId
          ? { ...visitor, IP_Health: newIpHealth }
          : visitor
      )
    );
  };

  function formatDateToMySQL(date) {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, "0"); // Months are zero-based
    const day = String(date.getDate()).padStart(2, "0");
    const hours = String(date.getHours()).padStart(2, "0");
    const minutes = String(date.getMinutes()).padStart(2, "0");
    const seconds = String(date.getSeconds()).padStart(2, "0");

    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
  }
  const filterRef = useRef(null);

  // Function to handle clicks outside the filter
  useEffect(() => {
    function handleClickOutside(event) {
      if (filterRef.current && !filterRef.current.contains(event.target)) {
        toggleSettings(false); // Close filter when clicking outside
      }
    }

    if (showSettings) {
      document.addEventListener("mousedown", handleClickOutside);
    }

    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [showSettings]);


  const applyDateRange = async () => {
    setLoading(true);
    setisFiltering(true);
    // Extract start_date and end_date from tempDateRange (ensure tempDateRange is an object with these fields)
    const { startDate, endDate } = tempDateRange[0];

    const formattedStartDate = formatDateToMySQL(startDate);
    const formattedEndDate = formatDateToMySQL(endDate);

    setDateRange(tempDateRange);
    setShowDatePicker(false); // Close date picker after applying the date range

    try {
      const response = await apiRequest('/api/client/visitor-history-filterbydate','POST',{
        user_id: user.userId, // Pass user ID from state or context
        start_date: formattedStartDate, // Start date of the range
        end_date: formattedEndDate, // End date of the range
      })
      
      // const data = await response.json();

      if (response) {
        setLoading(false);
        setVisitors(response.SearchData.sessionRows); // Update visitors with filtered data
        setfilteredTotalRecords(response.SearchData.totalRecords);
      } else {
        setError("Failed to fetch date-filtered results");
      }
    } catch (err) {
      setError("An error occurred while applying date filter");
    }
  };
  useEffect(() => {
    // const fetchBrands = async () => {
    //   try {
    //     const response = await axios-get(
    //       `${process.env.NEXT_PUBLIC_API_URL}/api/companies/${user.company_id}/brands`,
    //       {
    //         headers: {
    //           Authorization: `Bearer ${token}`,
    //         },
    //       }
    //     );
    //     setBrands(response.data);
    //     
    //     setFilteredBrand(response.data);
    //     // Map over fetched brands to extract their IDs and add them to selectedBrands
    //     setSelectedBrands((prev) => [
    //       ...prev,
    //       ...response.data.map((brand) => brand.id),
    //     ]);
    //   } catch (error) {
    //     console.error("Error fetching brands:", error);
    //   }
    // };

    const fetchBrands = async () => {
      try {
        const response = await apiRequest(`api/companies/${user.company_id}/brands`,"GET");
        setBrands(response);
        
        setFilteredBrand(response);
        setSelectedBrands((prev) => [
          ...prev,
          ...response.map((brand) => brand.id),
        ]);
      } catch (error) {
        console.error("Error fetching brands:", error);
      }
    };
    if (user?.company_id) {
      fetchBrands();
    }
  }, []);
  const handleSearchBrandChange = (e) => {
    setBrandSearch(e.target.value);
    const filtered = brands.filter((brand) =>
      brand.name.toLowerCase().includes(e.target.value.toLowerCase())
    );
    setFilteredBrand(filtered);
  };
  const selectAllBrands = () => {
    const allBrandIds = filteredBrands.map((brand) => brand.id);
    const areAllSelected = allBrandIds.every((id) => selectedBrands.includes(id));
 
    if (!areAllSelected) {
      setSelectedBrands(allBrandIds);
     
      searchVisitors(searchTerm, servedStatus, connectedStatus,includeClientId,includeEmail,includeMsg,includeName,selectedBrands);
      setFilterCurrentPage(1);
      setIsBrandChange((prev) => {
        // Ensure all brand IDs are toggled in the `isBrandChange` array
        const updatedBrandChanges = [...prev];
        allBrandIds.forEach((id) => {
          if (!updatedBrandChanges.includes(id)) {
            updatedBrandChanges.push(id); // Add brand if not already included
          }
        });
        searchVisitors(
          searchTerm,
          servedStatus,
          connectedStatus,
          includeClientId,
          includeEmail,
          includeMsg,
          includeName,
          updatedBrandChanges, // Pass the updated brands list here
        );
        return updatedBrandChanges;
      });
    }
  };
  

  const unselectAllBrands = () => {
    setSelectedBrands([]);
    searchVisitors(
      searchTerm,
      servedStatus,
      connectedStatus,
      includeClientId,
      includeEmail,
      includeMsg,
      includeName,
      [], // Pass the updated brands list here
    );
  };

  useEffect(() => {
    const socketinst = getSocket();
    if (!socketinst) return;
    const handleUpdateHistory = (data) => {
      const decryptedData = decryptData(data)

      // Assuming data contains the fields you specified
      const {
        client_id,
        client_name,
        served_by,
        chat_session_id,
        brand_name,
        landing_url,
        IP_Health,
        created_at,
        ip,
        country,
        visitor_session_id,
        browser,
        os,
        join_time,
        left_time,
        message_count,
      } = decryptedData;
      // Update NewHistoryRecieved state
      setNewHistoryRecieved((prevState) => [
        { visitor_session_id },
        ...prevState,
      ]);

      // Update visitor state
      // Append new visitor data to the existing visitors array
      setVisitors((prevState) => [
        {
          client_id,
          client_name,
          visitor_session_id,
          served_by,
          chat_session_id,
          brand_name,
          landing_url,
          IP_Health,
          created_at,
          ip,
          country,
          browser,
          os,
          join_time,
          message_count,
          left_time,
        },
        ...prevState,
      ]);
    };

    setSocket(socketinst);
    socketinst.on("client History updated", handleUpdateHistory);
    return () => {
      // Clean up event listeners
      socketinst.off("client History updated", handleUpdateHistory);
    };
  }, []);
  function emitTimeInUserTimezone(serverTime) {
    // Parse the server time (ISO format in UTC)
    const serverUtcTime = new Date(serverTime); // ISO string will be handled as UTC automatically

    // Get the user's local time zone (e.g., 'Asia/Karachi')
    const userTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;

    // Format the date part
    const dateOptions = {
      timeZone: userTimezone,
      day: "2-digit",
      month: "short", // Short month format (e.g., Nov)
      year: "numeric",
    };
    const datePart = new Intl.DateTimeFormat("en-US", dateOptions).format(
      serverUtcTime
    );

    // Format the time part
    const timeOptions = {
      timeZone: userTimezone,
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      hour12: true, // 12-hour format
    };
    const timePart = new Intl.DateTimeFormat("en-US", timeOptions).format(
      serverUtcTime
    );

    // Combine the date and time parts
    const formattedDate = `${datePart.replace(",", "")},${datePart
      .split(",")[1]
      .toLowerCase()} ${timePart}`;

    return formattedDate;
  }
  const calculateSessionTime = (joinTime, leftTime) => {
    const joinDate = new Date(joinTime);
    const leftDate = new Date(leftTime);

    // Calculate the difference in milliseconds
    const diffMs = leftDate - joinDate;

    // Convert milliseconds to hours, minutes, and seconds
    const hours = Math.floor(diffMs / (1000 * 60 * 60));
    const minutes = Math.floor((diffMs % (1000 * 60 * 60)) / (1000 * 60));
    const seconds = Math.floor((diffMs % (1000 * 60)) / 1000);

    return `${hours}h ${minutes}m ${seconds}s`;
  };

  const toggleDropdown = () => {
    setIsDropdownOpen(!isDropdownOpen);
  };

  const handleBrandChange = (brand) => {
    // Update selectedBrands state and retrieve the updated list
    const updatedBrands = selectedBrands.includes(brand.id)
      ? selectedBrands.filter((id) => id !== brand.id)
      : [...selectedBrands, brand.id];
  
    setSelectedBrands(updatedBrands); // Update the state with the new list
  
    
  
    // Pass the updated list to the search function
    searchVisitors(
      searchTerm,
      servedStatus,
      connectedStatus,
      includeClientId,
      includeEmail,
      includeMsg,
      includeName,
      updatedBrands, // Pass the updated brands list here
    );
  };
  

  //opening side tab
  const openSideTab = (chatSession) => {
    if (
      chatSession &&
      chatSession.visitor_session_id === chatSessionId?.visitor_session_id
    ) {
      setHideColumns(false);

      SetChatSessionId(null);
    } else {
      SetChatSessionId(chatSession);
      // Remove visitor_session_id from NewHistoryRecieved when matched
      setNewHistoryRecieved((prevState) =>
        prevState.filter(
          (history) =>
            history.visitor_session_id !== chatSession.visitor_session_id
        )
      );
      setHideColumns(true);
    }
  };
  const dummyBrands = [
    { id: 1, name: "Brand A" },
    { id: 2, name: "Brand B" },
    { id: 3, name: "Brand C" },
  ];

  // const handleSearchChange = (e) => {
  //   const term = e.target.value;
  //   setSearchTerm(term);
  //   searchVisitors(term);
  // };

  const toggleSettings = () => {
    setShowSettings(!showSettings);
  };

  // const handleBrandChange = (brandId) => {
  //   setSelectedBrands((prev) =>
  //     prev.includes(brandId)
  //       ? prev.filter((id) => id !== brandId)
  //       : [...prev, brandId]
  //   );
  // };

  // Handle sorting columns
  // Debounced search function with pagination
  
  
  const searchVisitors = useCallback(
    debounce(
      async (
        term,
        statusServed = servedStatus,
        statusConnected = connectedStatus,
        includeClientId = true,
        includeEmail = true,
        includeMsg = true,
        includeName = true,
        selectedBrands = filteredBrands.map((brand) => brand.id),
        page = 1
        ) => {
        setisFiltering(true);
        setLoading(true);
        setError(null);
  
        try {
          
          
  
          // Build the payload dynamically
          const payload = {
            user_id: user.userId,
            searchTerm: /^\s*$/.test(term) ? "" : term,
            brandIds: selectedBrands,
            includeName,
            includeEmail,
            includeClientId,
            includeMsg,
            currentPage: page,
            itemsPerPage: 10,
          };
  
          // Use passed arguments if available; otherwise, fallback to state
          if (statusServed) {
            payload.servedStatus = statusServed;
          }
          if (statusConnected) {
            payload.connectedStatus = statusConnected;
          }
            const response =await apiRequest('/api/client/visitor-history-search','POST',(payload))
          // const response = await fetch(
          //   `${process.env.NEXT_PUBLIC_API_URL}/api/client/visitor-history-search`,
          //   {
          //     method: "POST",
          //     headers: {
          //       "Content-Type": "application/json",
          //     },
          //     body: JSON.stringify(payload),
          //   }
          // );
  
          // const data = await response.json();
            
            
          if (response) {
            console.log(response)
            setVisitors(response.SearchData.sessionRows);
            setfilteredTotalRecords(response.SearchData.totalRecords);
            setFilterTotalPages(Math.ceil(response.SearchData.totalRecords / 50));
          } else {
            setError("Failed to fetch search results");
          }
        } catch (err) {
          setError("An error occurred while searching");
        }
  
        setLoading(false);
      },
      500
    ),
    [selectedBrands, includeName, includeEmail, includeClientId, includeMsg, servedStatus, connectedStatus]
  );
  
  

  const handleFilterChange = (filterType, value) => {
    switch (filterType) {
      case "includeName":
        setIncludeName(!includeName );
        if(searchTerm.length>0)
          searchVisitors(searchTerm, servedStatus, connectedStatus,includeClientId,includeEmail,includeMsg,!includeName,selectedBrands);
        break;
      case "includeEmail":
        setIncludeEmail(!includeEmail);
         if(searchTerm.length>0)
        searchVisitors(searchTerm, servedStatus, connectedStatus,includeClientId,!includeEmail,includeMsg,includeName,selectedBrands);
        break;
      case "includeClientId":
        setIncludeClientId(!includeClientId);
        // searchVisitors(!includeClientId)
        if(searchTerm.length>0)
          searchVisitors(searchTerm, servedStatus, connectedStatus,!includeClientId,includeEmail,includeMsg,includeName,selectedBrands);
        break;
      case "includeMsg":
        setincludeMsg(!includeMsg);
        if(searchTerm.length>0)
          searchVisitors(searchTerm, servedStatus, connectedStatus,includeClientId,includeEmail,!includeMsg,includeName,selectedBrands);
        break;
      default:
        break;
    }
    

    // searchVisitors(searchTerm);
  };
const handleStatusChange = (statusType, value) => {
  if (statusType === "servedStatus") {
    setservedStatus(value);
    
      searchVisitors(searchTerm, value, connectedStatus,includeClientId,includeEmail,includeMsg,includeName,selectedBrands);
  } else if (statusType === "connectedStatus") {
    setconnectedStatus(value);
  
      searchVisitors(searchTerm, servedStatus, value,includeClientId,includeEmail,includeMsg,includeName,selectedBrands); // Pass the current `servedStatus` and the updated `connectedStatus`
  }
};

  
  // useEffect(() => {
  //   setFilterCurrentPage(1);
  //   searchVisitors(searchTerm);
  // }, [servedStatus,connectedStatus])
  
  // useEffect(() => {
  //   
  //   if(IsBrandChange.length >0){
  //     setFilterCurrentPage(1);
  //     // searchVisitors(searchTerm);
 
     
  //       searchVisitors(searchTerm, servedStatus, connectedStatus,includeClientId,includeEmail,includeMsg,includeName,selectedBrands);
  //     
  //   }
 
  // }, [
  //   searchTerm,
  
  //   IsBrandChange,
  
  // ]);

  // useEffect(() => {
  //   if (isFiltering) {
  //     
  //     
      
       
  //       searchVisitors(searchTerm, servedStatus, connectedStatus,!includeClientId,includeEmail,includeMsg,includeName,filterCurrentPage);
  //   }
  // }, [filterCurrentPage]);

  const clearDateFilter = () => {
    setDateRange(null);
    setisFiltering(false);
    setfilteredTotalRecords(0);
    setVisitors(allVisitors);
  };

  // Fetch visitors on component mount and when page changes

  // Handle the search term change
  const handleSearchChange = (e) => {
    const term = e.target.value;
    setFilterCurrentPage(1);

    setFilterTotalPages(1);
    setSearchTerm(term);
   
    
      searchVisitors(term, servedStatus, connectedStatus,includeClientId,includeEmail,includeMsg,includeName,selectedBrands);
  };

  // Fetch data from the API
  const fetchVisitors = async (page) => {
    setLoading(true);
    setError(null);
    try {
      
      
      const response =await apiRequest(`/api/client/visitor-history?page=${page}&limit=${limit}`,'POST',{user_id:user.userId})
      // const response = await fetch(
      
      //   `${process.env.NEXT_PUBLIC_API_URL}/api/client/visitor-history?page=${page}&limit=${limit}`,
      //   {
      //     method: "POST", // Using POST instead of GET
      //     headers: {
      //       "Content-Type": "application/json",
      //     },
      //     body: JSON.stringify({
      //       user_id: user.userId, // Add the user_id here
      //     }),
      //   }
      // );

      // const data = await response.json();
      

      if (response) {
        setVisitors(response.data); // assuming the API returns an array of results
        setTotalPages(response.totalPages); // assuming the API sends total pages
        setTotalRecords(response.totalRecords); // assuming the API sends total records
        setAllVisitors(response.data); // Store all visitors for searching
      } else {
        setError("Failed to fetch data");
      }
    } catch (err) {
      setError("An error occurred while fetching data");
    }
    setLoading(false);
  };

  // // Fetch visitors on component mount and when page changes
  // useEffect(() => {
  //   fetchVisitors(currentPage);
  // }, [currentPage]);
  // const fetchVisitorsStream = (page) => {
  //   const eventSource = new EventSource(
  //     `${process.env.NEXT_PUBLIC_API_URL}/api/client/visitor-history-stream?user_id=${user.userId}&page=${page}&limit=${limit}`
  //   );
  
  
  //   setVisitors([]); // reset
  //   setLoading(true);
  
  //   eventSource.onmessage = (e) => {
  //     const visitor = JSON.parse(e.data);
  //     console.log(visitor);
  //     setLoading(false)
  //     setVisitors(prev => [...prev, visitor]);
  //   };
  
  //   eventSource.addEventListener("done", () => {
  //     setLoading(false);
  //     eventSource.close();
  //   });
  
  //   eventSource.addEventListener("error", (e) => {
  //     console.error("SSE error", e);
  //     setError("Stream failed");
  //     setLoading(false);
  //     eventSource.close();
  //   });
  
  //   return () => {
  //     eventSource.close();
  //   };
  // };
  
  // Fetch visitors on component mount and when page changes
  useEffect(() => {
    fetchVisitors(currentPage);
    // fetchVisitorsStream(currentPage)
  }, [currentPage]);
  // Handle next and previous page buttons
  const handleNextPage = () => {
    if (currentPage < totalPages) {
      setCurrentPage((prev) => prev + 1);
    }
    
  };

  const handlePreviousPage = () => {
    if (currentPage > 1) {
      setCurrentPage((prev) => prev - 1);
    }
  };
  const handleResetFilter = () => {
 
    setSearchTerm("");
    const allBrandIds = filteredBrands.map((brand) => brand.id);
    const areAllSelected = allBrandIds.every((id) => selectedBrands.includes(id));
 
    if (!areAllSelected) {
      setSelectedBrands(allBrandIds);
     
      // searchVisitors(searchTerm, servedStatus, connectedStatus,includeClientId,includeEmail,includeMsg,includeName,selectedBrands);
      setFilterCurrentPage(1);
    
    }
     
    setfilteredTotalRecords(0);
    setIncludeName(true);
    setIncludeEmail(true);
    setIncludeClientId(true);
    setincludeMsg(true);
    setservedStatus('all');
    setconnectedStatus('all');
    setisFiltering(false);
    setVisitors(allVisitors);
  };
  
  const getBrowserName = (browser) => {
    if (browser?.includes("Chrome")) {
      return "chrome";
    } else if (browser?.includes("Firefox")) {
      return "firefox";
    } else if (browser?.includes("Safari") && !browser?.includes("Chrome")) {
      return "safari";
    } else if (browser?.includes("Edge")) {
      return "edge";
    } else if (browser?.includes("Trident")) {
      return "ie";
    }
    return "unknown";
  };
  // Helper to get browser icon as an image
  const getBrowserIcon = (browser) => {
    let brows = getBrowserName(browser);
    switch (brows?.toLowerCase()) {
      case "chrome":
        return <img src={chrome.src} className="browser-icon" />;
      case "firefox":
        return <img src={firefox.src} className="browser-icon" alt="firefox" />;
      case "safari":
        return <img src={safari.src} className="browser-icon" alt="safari" />;
      case "edge":
        return <img src={edge.src} className="browser-icon" alt="edge" />;
      case "ie":
        return <img src={edge.src} className="browser-icon" alt="ie" />;
      default:
        return null;
    }
  };
  const getCountryFlag = (country) => {
    const countryCode = countryNameToCode[country];
    return countryCode ? (
      <img
        src={`https://flagcdn.com/80x60/${countryCode}.png`}
        alt={`${country} flag`}
        width="24"
        height="18"
      />
    ) : null;
  };
  // Helper to get OS icon as an image
  const getOSIcon = (os) => {
    switch (os?.toLowerCase()) {
      case "windows":
        return <img src={windows.src} alt="Windows" className="os-icon" />;

      case "mac":
      case "macos":
      case "apple":
        return <img src={Ios.src} alt="Apple" className="os-icon" />;

      case "linux":
        return <img src={ubunto.src} alt="Linux" className="os-icon" />;

      case "android":
        return <img src={android.src} alt="Android" className="os-icon" />;

      case "ios":
      case "iphone":
      case "ipad":
        return <img src={Ios.src} alt="iOS" className="os-icon" />;

      case "unix":
        return (
          <img
            src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/35/Tux.svg/1200px-Tux.svg.png"
            alt="UNIX"
            className="os-icon"
          />
        );

      default:
        return null;
    }
  };

  return (
    <>
      <div className="container-fluid top-bar">
        <div className="left-div">
          <h2>History</h2>
        </div>
        <div className="right-div"></div>
      </div>
       {showSettings &&
       
        <div className="overlay"></div>
       }
      <div className="comp-header-row d-flex justify-content-between flex-row-relative">
      <div className="search-container">
        <div className="input-group">
          <input
            type="text"
            className="form-control"
            placeholder="Search by name | email | phone..."
            value={searchTerm}
            onChange={handleSearchChange}
          />
          <span className="input-group-text history-search-icon bg-transparent border-0">
            <FaSearch size={12} />
          </span>
          <span
            className="input-group-text bg-transparent border-0"
            onClick={() => toggleSettings(!showSettings)}
            
            title="filter"
          >
            <FaFilter size={12} />
          </span>
          {isFiltering && (
            <span
              className="input-group-text bg-transparent border-0"
              onClick={handleResetFilter}
              title="reset"
            >
              <FaFilterCircleXmark size={13} />
            </span>
          )}
        </div>

        {showSettings && (
          <div className="filter-overlay">
            {/* Background Layer */}
            <div className="filter-background" onClick={() => toggleSettings(false)}></div>

            {/* Filter Bar */}
            <div className="history-filter-bar" ref={filterRef}>
              <div className="settings-dropdown">
                <h6>Filter Options</h6>
                <div className="checkbox-group">
                  <div>
                    <input
                      type="checkbox"
                      id="includeName"
                      checked={includeName}
                      onChange={(e) =>
                        handleFilterChange("includeName", e.target.checked)
                      }
                    />
                    <label htmlFor="includeName"> Name</label>
                  </div>
                  <div>
                    <input
                      type="checkbox"
                      id="includeEmail"
                      checked={includeEmail}
                      onChange={(e) =>
                        handleFilterChange("includeEmail", e.target.checked)
                      }
                    />
                    <label htmlFor="includeEmail"> Email</label>
                  </div>
                  <div>
                    <input
                      type="checkbox"
                      id="includeClientId"
                      checked={includeClientId}
                      onChange={(e) =>
                        handleFilterChange("includeClientId", e.target.checked)
                      }
                    />
                    <label htmlFor="includeClientId"> Client ID</label>
                  </div>
                  <div>
                    <input
                      type="checkbox"
                      id="includeMsg"
                      checked={includeMsg}
                      onChange={(e) =>
                        handleFilterChange("includeMsg", e.target.checked)
                      }
                    />
                    <label htmlFor="includeMsg"> Messages</label>
                  </div>
                </div>

                {/* Select Filters */}
                <div className="filter-select">
                  <div className="select-row">
                    <label htmlFor="servedStatus">Served Status</label>
                    <select
                      id="servedStatus"
                      value={servedStatus}
                      onChange={(e) =>
                        handleStatusChange("servedStatus", e.target.value)
                      }
                    >
                      <option value="all">All </option>
                      <option value="not_served">Not Served</option>
                      <option value="served">Served</option>
                    </select>
                  </div>

                  <div className="select-row">
                    <label htmlFor="connectedStatus">Connected Status</label>
                    <select
                      id="connectedStatus"
                      value={connectedStatus}
                      onChange={(e) =>
                        handleStatusChange("connectedStatus", e.target.value)
                      }
                    >
                      <option value="all">All </option>
                      <option value="connected">Connected</option>
                      <option value="not_connected">Not Connected</option>
                    </select>
                  </div>
                </div>

                <div className="multi-select">
                  <button type="button" onClick={toggleDropdown}>
                    Select Brands
                  </button>
                  <div
                    className={`multi-select-options ${
                      isDropdownOpen ? "active" : ""
                    }`}
                  >
                    <div className="toggle-buttons">
                      <button onClick={selectAllBrands} className="toggle-btn">
                        Select All
                      </button>
                      <button onClick={unselectAllBrands} className="toggle-btn">
                        Unselect All
                      </button>
                    </div>
                    <input
                      type="text"
                      placeholder="Search brands..."
                      value={brandSearch}
                      onChange={handleSearchBrandChange}
                      className="brand-search-input"
                    />
                    {filteredBrands.map((brand) => (
                      <label key={brand.id}>
                        <input
                          type="checkbox"
                          value={brand.name}
                          checked={selectedBrands.includes(brand.id)}
                          onChange={() => handleBrandChange(brand)}
                        />
                        {brand.name}
                      </label>
                    ))}
                  </div>
                </div>
              </div>
            </div>
          </div>
        )}
        </div>

        <div>
          <button
            className="btn date-filter-btn"
            onClick={() => setShowDatePicker(!showDatePicker)}
          >
            {dateRange
              ? `${dateRange[0].startDate.toLocaleDateString()} - ${dateRange[0].endDate.toLocaleDateString()}`
              : "Filter by Date"}
          </button>
          {showDatePicker && (
            <div className="date-picker-container history-date-picker">
              <DateRangePicker
                ranges={tempDateRange}
                onChange={handleSelect}
                moveRangeOnFirstSelection={false}
                editableDateInputs={true}
                showSelectionPreview={true}
                months={2} // Display two calendars
                direction="horizontal" // Side-by-side calendars
                className="small-calendar"
              />
              <button
                className="btn btn-success mt-2 accept-btn"
                onClick={applyDateRange}
              >
                Accept
              </button>
            </div>
          )}

          {dateRange && (
            <button
              className=" ms-2 btn date-filter-btn"
              onClick={clearDateFilter}
            >
              Clear Date Filter
            </button>
          )}
        </div>

        <style jsx>{`
          .small-calendar .rdrCalendarWrapper {
            transform: scale(0.85); // Adjust calendar size for better UI
          }
          .small-calendar .rdrCalendarWrapper .rdrMonths {
            gap: 20px; // Add space between calendars
          }
          .date-picker-container {
            background: white;
            border: 1px solid #ddd;
            padding: 10px;
            border-radius: 8px;
          }
          .btn-success {
            width: 100%;
          }
        `}</style>
      </div>
      <div className="history-visitors-total-records">
        <p>
          Total Records:{" "}
          {filteredTotalRecords > 0 ? filteredTotalRecords : totalRecords}
        </p>
      </div>

      <div className="chat-visitor-container">
        <div className="chat-main-content">
          {loading ? (
            <LoadingSkeletonTable />
          ) : error ? (
            <p>{error}</p>
          ) : (
            <>
              <table
                cellPadding={5}
                cellSpacing={5}
                border={1}
                className="table table-responsive chat-stats-table history-visitors-table"
              >
                <thead>
                  <tr>
                    {/* <th>ID</th> */}
                    <th>Client ID</th>
                    <th>Name</th>
                    <th>Served By</th>
                    <th>Messages</th>
                    <th>Platform</th>
                    <th>Brand</th>
                    <th className={chatSessionId ? "d-none" : ""}>Landing Page</th>
                    <th className={chatSessionId ? "d-none" : ""}>IP</th>
                    <th className={chatSessionId ? "d-none" : ""}>Join At</th>
                    <th className={chatSessionId ? "d-none" : ""}>Duration</th>
                    <th className={chatSessionId ? "d-none" : ""}>IP Health</th>
                  </tr>
                </thead>
                <tbody>
                  {}
                  {visitors.map((visitor, index) => (
                    <tr
                      key={index}
                      onClick={() => openSideTab(visitor)}
                      className={`pointer-cursor ${
                        chatSessionId?.visitor_session_id ===
                        visitor.visitor_session_id
                          ? "active-history-row"
                          : ""
                      } ${
                        NewHistoryRecieved.some(
                          (history) =>
                            history.visitor_session_id ===
                            visitor.visitor_session_id
                        )
                          ? "new-history-row"
                          : ""
                      }`}
                    >
                      {/* <td>{visitor.visitor_session_id || 'N/A'}</td> */}
                      <td className="history-table-column">{visitor.client_id || "N/A"}</td>
                      <td className="history-table-column">{visitor.client_name || "N/A"}</td>

                      <td className="served_by history-table-column">
                        {visitor.served_by || "N/A"}
                      </td> 
                      <td className="message-count history-table-column">{visitor.message_count  }</td>
                      <td className="browser-info history-table-column">
                        {/* Browser Icon with Tooltip */}
                        <div className="tooltip">
                          {getBrowserIcon(visitor?.browser) || "N/A"}
                          <span className="tooltiptext">
                            Browser: {visitor?.browser || "N/A"}
                            <div className="tooltip-arrow"></div>
                          </span>
                        </div>

                        {/* OS Icon with Tooltip */}
                        <div className="tooltip">
                          {getOSIcon(visitor?.os) || "N/A"}
                          <span className="tooltiptext">
                            OS: {visitor?.os || "N/A"}
                            <div className="tooltip-arrow"></div>
                          </span>
                        </div>

                        {/* Country Flag with Tooltip */}
                        <div className="tooltip">
                          {getCountryFlag(visitor?.country) || "N/A"}
                          <span className="tooltiptext">
                            Country: {visitor?.country || "N/A"}
                            <div className="tooltip-arrow"></div>
                          </span>
                        </div>
                      </td>
                      <td className="history-table-column">{visitor.brand_name || "N/A"}</td>
                      <td className={  chatSessionId ? "d-none " : " history-table-column history-landing-url"}>
                        {visitor.landing_url || "N/A"}
                      </td>
                    
                      <td className={chatSessionId ? "d-none " : " history-table-column"}>
                        {visitor.ip || "N/A"}
                      </td>
                      <td className={chatSessionId ? "d-none " : "history-table-column"}>
                        {emitTimeInUserTimezone(visitor.join_time) || "N/A"}
                      </td>
                      <td className={chatSessionId ? "d-none" : "history-table-column"}>
                        {calculateSessionTime(
                          visitor.join_time,
                          visitor.left_time
                        ) || "N/A"}
                      </td>
                      <td className={chatSessionId ? "d-none" : "history-table-column"}>
                        {visitor.IP_Health === 1
                          ? "Good"
                          : visitor.IP_Health === 0
                          ? "Bad"
                          : "N/A"}
                      </td>
                    </tr>
                  ))}
                </tbody>
              </table>

              {/* Pagination Controls */}
              {!isFiltering && (
                <div className="pagination-controls">
                  <button
                    onClick={handlePreviousPage}
                    disabled={currentPage === 1}
                  >
                    Previous
                  </button>
                  <span>
                    Page {currentPage} of {totalPages}
                  </span>
                  <button
                    onClick={handleNextPage}
                    disabled={currentPage === totalPages}
                  >
                    Next
                  </button>
                </div>
              )}
              {isFiltering && (
                <div className="pagination-controls">
                  <button
                    onClick={() =>{
                      searchVisitors(searchTerm, servedStatus, connectedStatus,!includeClientId,includeEmail,includeMsg,includeName,selectedBrands,(filterCurrentPage-1));
                      setFilterCurrentPage((prev) => Math.max(prev - 1, 1))
                    }
                    }
                    disabled={filterCurrentPage === 1}
                  >
                    Previous
                  </button>
                  <span>
                    Pagez {filterCurrentPage} of {filterTotalPages}
                  </span>
                  <button
                    onClick={() =>{
                      searchVisitors(searchTerm, servedStatus, connectedStatus,!includeClientId,includeEmail,includeMsg,includeName,selectedBrands,(filterCurrentPage+1));
                      setFilterCurrentPage((prev) =>
                        Math.min(prev + 1, filterTotalPages)
                      )
                    }
                    }
                    disabled={filterCurrentPage === filterTotalPages}
                  >
                    Next
                  </button>
                </div>
              )}
            </>
          )}
        </div>
        {hideColumns && (
          <SessionChat
            chat_session_id={chatSessionId.chat_session_id}
            currentChat={chatSessionId}
            setHideColumns={setHideColumns}
            setCurrentChat={SetChatSessionId}
            updateIpHealth={updateIpHealth}
          />
        )}
      </div>
    </>
  );
};

export default History;
