import React from "react";

const MessageWithLink = ({ message }) => {
  // Function to convert URLs in text into clickable links
    const renderMessage = (msg) => {
        const urlRegex = /(https?:\/\/[^\s]+)/g;
    return msg.split(urlRegex).map((part, index) => {
      // If the part matches the URL regex, render it as a link
      if (urlRegex.test(part)) {
        return (
          <a
            key={index}
            href={part}
            target="_blank"
            rel="noopener noreferrer"
            style={{ color: "#5a5a5c", textDecoration: "underline" }}
          >
            {part}
          </a>
        );
      }
      // Otherwise, render it as plain text
      return part;
    });
  };

  return <p className="m-0 user-msg">{renderMessage(message)}</p>;
};

export default MessageWithLink;
