import React, { useState, useEffect, useRef } from "react";
 
import { HiEmojiHappy } from "react-icons/hi";
import { AiFillDislike, AiFillLike, AiOutlineLike } from "react-icons/ai";
import { IoIosAttach } from "react-icons/io";
import { getSocket } from "@/app/lib/socketManager";
import axios from "axios";
import VisitorDetails from "./VisitorDetails";
 
import dynamic from "next/dynamic";
import { FaAngleDoubleDown } from "react-icons/fa";
import { decryptData, decryptData } from "@/app/utils/DecryptData";
const EmojiPicker = dynamic(() => import('emoji-picker-react'), {
  ssr: false, // Ensure that it's not rendered on the server side
});
  
const ChatVisitor = ({
  currentChat,
  originalJoinTimes,
  setHideColumns,
  setCurrentChat,
}) => {
  const socket = getSocket();
  const [messages, setMessages] = useState([]);
  const [newMessage, setNewMessage] = useState("");
  const [userIsScrolledUp, setUserIsScrolledUp] = useState(false);
  const messagesContainerRef = useRef(null);
  const isUserAtBottom = useRef(true);
  const [typingUsers, setTypingUsers] = useState(new Set());
  const lastSeenMessageId = useRef(null); // Store the last seen message ID
  const [lastMessageId, setlastMessageId] = useState(null);
  const [isLoadingOldMessages, setIsLoadingOldMessages] = useState(false);
  const [isOldChat, setisOldChat] = useState(false);
  const [unseenCount, setUnseenCount] = useState();
  const [hasOldMessages, setHasOldMessages] = useState(false);
  const [previousScrollHeight, setPreviousScrollHeight] = useState(0);
  const [isAtBottom, setIsAtBottom] = useState(true);
  const [noMoreOldChats, setnoMoreOldChats] = useState(true);
  const [showPicker, setShowPicker] = useState(false);
  const [chatRating, setchatRating] = useState(3)
  const [isClientSeenMsg, setisClientSeenMsg] = useState()
  const pickerRef = useRef(null); // Reference for the emoji picker
  // Fetch chat history when the component mounts
  useEffect(() => {
    setIsAtBottom(true);
    if (true) {
      messagesContainerRef.current.scrollTop =
        messagesContainerRef.current.scrollHeight;
    }
    

  
    setHasOldMessages(false);
    setPreviousScrollHeight(0);
    fetchChatHistory();
  }, [currentChat.client_id]);
  const fetchChatHistory = async (lastMessageId = null, isOldChat = false) => {
    setIsLoadingOldMessages(true);
    try {
      const response = await fetch(
        `${process.env.NEXT_PUBLIC_API_URL}/api/chat/messages`,
        {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify({
            chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
            lastMessageId,
            isOldChat,
          }),
        }
      );
      const data = await response.json();

      if (data.messages) {
        
        
        if (isOldChat) {
          setMessages((prevMessages) => [...prevMessages, ...data.messages]);
          setHasOldMessages(data.messages.length > 0); // Check if old messages exist
          setnoMoreOldChats(data.oldChat);
        } else {
          setMessages(data.messages);
          messagesContainerRef.current.scrollTop =
            messagesContainerRef.current.scrollHeight;
          messagesContainerRef.scrollTop = messagesContainerRef.scrollHeight;
          
        }
         // Find the last admin message and check if it's seen by the client
        // Check if the first message is of type 'admin' and is_seen is 1
      if (data.messages[0].type === 'admin' && data.messages[0].is_seen === 1) {
        setisClientSeenMsg(true); // Set seen flag if the first message is seen
      } else {
        setisClientSeenMsg(false);
      }

        // Scroll to the bottom if user is at the bottom
        if (isUserAtBottom.current) {
          // messagesContainerRef.current.scrollTop = messagesContainerRef.current.scrollHeight;
        }
        // messagesContainerRef.current.scrollTop = messagesContainerRef.current.scrollHeight;
      }
    } catch (error) {
      console.error("Error fetching chat history:", error);
    } finally {
      setIsLoadingOldMessages(false);
    }
  };

  function convertUtcToLocal(utcTimestamp, locale = "en-US") {
    const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
    const date = new Date(utcTimestamp);

    const now = new Date();

    // Create local copies of today and yesterday's start
    const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
    const yesterday = new Date(today);
    yesterday.setDate(today.getDate() - 1);

    // Formatting options
    const timeOptions = {
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      timeZone,
    };
    const dateOptions = {
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      timeZone,
    };

    // Check if the timestamp is from today
    if (date >= today) {
      return `Today ${date.toLocaleTimeString(locale, timeOptions)}`;
    }

    // Check if the timestamp is from yesterday
    if (date >= yesterday && date < today) {
      return `Yesterday ${date.toLocaleTimeString(locale, timeOptions)}`;
    }

    // For timestamps older than yesterday, return date + time
    return `${date.toLocaleDateString(
      locale,
      dateOptions
    )} ${date.toLocaleTimeString(locale, timeOptions)}`;
  }
  // Socket listeners for new messages and typing indicators
  useEffect(() => {
    socket.on("chat message", (message) => {
      // const message = decryptData(encryptedData)
      const room = `${currentChat?.public_key}_${currentChat?.client_id}`;
      if (message.room === room) {
        setMessages((prevMessages) => [message, ...prevMessages]);
      }
    });
    socket.on(
      "chat rating",(encryptedData)=>{
        const ratingData = decryptData(encryptedData)
        if(currentChat.client_id == ratingData.client_id){
          setchatRating(ratingData.rating)
          
          
        }
      }
    );
    socket.on(
      "rating submit by client",(encryptedData)=>{
        const ratingData = decryptData(encryptedData)
        if(currentChat.client_id == ratingData.client_id){
          setchatRating(ratingData.rating)
          
          
        }
      }
    )
    

    socket.on("message_seen by client", (encryptedData) => {
      const data = decryptData(encryptedData)
    
    
      if (currentChat.client_id == data.client_id) {
        
        
        // Update the message state to reflect the seen status for the correct message
        setMessages((prevMessages) =>
          prevMessages.map((message) =>
            message.messageId == data.message_id
              ? { ...message, is_seen: 1 } // Update the specific message to seen
              : message
          )
        );
      }
    }); socket.on("typing", (data) => {
      // const decryptData = decryptData(data)
      setTypingUsers((prevTypingUsers) =>
        new Set(prevTypingUsers).add(data.name)
      );
    });

    socket.on("stop typing", (data) => {
      // const data = decryptData(encryptedData)
      setTypingUsers((prevTypingUsers) => {
        const updatedTypingUsers = new Set(prevTypingUsers);
        updatedTypingUsers.delete(data.name);
        return updatedTypingUsers;
      });
    });
    socket.on("chat history", (data) => {
      
    });

    return () => {
      socket.off("chat message");
      socket.off("typing");
      socket.off("stop typing");
    };
  }, [socket, currentChat]);
  const checkIfAtBottom = () => {
    const container = messagesContainerRef.current;
    if (container) {
      const isUserAtBottom =
        Math.abs(
          container.scrollHeight - container.scrollTop - container.clientHeight
        ) <= 2;
      setIsAtBottom(isUserAtBottom);
      
      return isUserAtBottom;
    }
  };

  useEffect(() => {
    const container = messagesContainerRef.current;
    const hasScrollBar = container.scrollHeight > container.clientHeight;
    const scrollableHeight = container.scrollHeight;
    const scrollPosition = container.scrollTop;
    const visibleHeight = container.clientHeight;

    // Distance from the bottom
    const distanceFromBottom =
      scrollableHeight - (scrollPosition + visibleHeight);

    
  

    // Get the current scroll position from the top
    const distanceFromTop = container.scrollTop;
    
 
    if (hasScrollBar && isAtBottom) {
      messagesContainerRef.current.scrollTop =
        messagesContainerRef.current.scrollHeight;
    } 
    if (isAtBottom && messages.length > 0) {
      const latestMessage = messages[0];
      
      

      if (
        (currentChat && latestMessage.from !== currentChat.pseudonym) ||
        latestMessage.msgtype === "comment"
      ) {
        

        socket.emit("is_chat_seen", {
          chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
          client_id: currentChat?.client_id,
          public_key: currentChat?.public_key,
          isSeen: 1,
          
        });
        lastSeenMessageId.current = latestMessage.messageId;
        setUnseenCount(0); // Reset unseen count once messages are seen
      }
    } else if (container && isAtBottom) {
      container.scrollTop = container.scrollHeight; // Scroll to the bottom
      
    }
    socket.on("chat message", (message) => {
        // const message = decryptData(encryptedData)
      
      setisClientSeenMsg(false)
          
      if (message.from == currentChat.client_id)
      {
        setUnseenCount((prev) => prev + 1); // Increment unseen count
         
      }
    });
  }, [messages, currentChat,isClientSeenMsg]);

  const handleScroll = () => {
    const container = messagesContainerRef.current;

    const isAtBottom = checkIfAtBottom();

    if (container) {
      const scrollableHeight = container.scrollHeight;
      const scrollPosition = container.scrollTop;
      const visibleHeight = container.clientHeight;

      // Distance from the bottom
      const distanceFromBottom =
        scrollableHeight - (scrollPosition + visibleHeight);

       
      // Get the current scroll position from the top
      const distanceFromTop = container.scrollTop;

     
      

      if (isAtBottom && messages.length > 0) {
        

        const latestMessage = messages[messages.length - 1];
        if (currentChat && latestMessage.from !== currentChat.pseudonym) {
          socket.emit("is_chat_seen", {
            chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
            client_id: currentChat?.client_id,
            public_key: currentChat?.public_key,
            isSeen: 1,
          });
          lastSeenMessageId.current = latestMessage.messageId;
          setUnseenCount(0); // Reset unseen count once messages are seen
        }
      }

      // Detect when the user scrolls to the top to fetch older messages
      if (container.scrollTop === 0 && messages.length > 0 && hasOldMessages) {
        
        setIsLoadingOldMessages(true);
        const messagelength = messages.length;
        const firstMessageId = messages[messagelength - 1].messageId; // First message ID
        setPreviousScrollHeight(container.scrollHeight); // Save the previous scroll height

        
        if (noMoreOldChats) {
          fetchChatHistory(firstMessageId, true).then(() => {
            // After fetching, adjust scroll position
            const newHeight = container.scrollHeight; // New height after loading messages
            const scrollOffset = newHeight - previousScrollHeight; // Calculate the offset
            container.scrollTop = scrollOffset; // Adjust scroll position
            setIsLoadingOldMessages(false);
          });
        }
      }
    }
  };

  // Add a useEffect to handle showing the notification icon
  useEffect(() => {
    if (unseenCount > 0) {
      // Logic to display the notification icon
      
      // You can also trigger a UI update here to show the notification icon
    }
  }, [unseenCount]);

  // Add an event listener for scroll
  useEffect(() => {
    const container = messagesContainerRef.current;
    if (container) {
      container.addEventListener("scroll", handleScroll);
      return () => container.removeEventListener("scroll", handleScroll);
    }
  }, []);

  const handleSendMessage = () => {
    setisClientSeenMsg(false)
    socket.emit("stop typing admin", {
      chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
      from: currentChat?.pseudonym,
    });
    if (newMessage.trim() === "") return;
    const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;

    const messageData = {
      client_id: currentChat?.client_id,
      public_key: currentChat?.public_key,
      msg: newMessage,
      from: currentChat?.pseudonym,
      sent_at: new Date().toISOString(), // Include timestamp when sending message
      type:"chat"
    };

    socket.emit("admin message", messageData);
    setNewMessage("");
   
  };

  const handleInputChange = (event) => {
    setNewMessage(event.target.value);
    if (event.target.value.trim()) {
      socket.emit("typing admin", {
        chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
        from: currentChat?.pseudonym,
      });
    } else {
      socket.emit("stop typing admin", {
        chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
        from: currentChat?.pseudonym,
      });
    }
  };

  const handleKeyDown = (event) => {
    if (event.key === "Enter" && !event.shiftKey) {
      event.preventDefault();
      handleSendMessage();
    }
  };

  useEffect(() => {
    if (!userIsScrolledUp) {
      isUserAtBottom.current = true;
    }
  }, [newMessage,isClientSeenMsg]);
  const fetchOldMessages = () => {
    

    setHasOldMessages(true);
    const messagesLength = messages.length;
    const firstMessageId = messages[messagesLength - 1].messageId;
    const container = messagesContainerRef.current;

    // Save the previous scroll height before fetching new messages
    const previousScrollHeight = container.scrollHeight;

    

    // Fetch chat history
    fetchChatHistory(firstMessageId, true).then(() => {
      // Use requestAnimationFrame to ensure the DOM has updated before recalculating scroll position
      requestAnimationFrame(() => {
        const newHeight = container.scrollHeight; // Get the new height after loading messages
        setPreviousScrollHeight(newHeight);
        const scrollOffset = newHeight - previousScrollHeight; // Calculate the difference
        container.scrollTop = scrollOffset; // Adjust scroll position
        

        // Stop loading indicator for old messages
        setIsLoadingOldMessages(false);
      });
    });
  };
  // Function to handle when an emoji is clicked
  const onEmojiClick = (emojiData) => {
    // Access the selected emoji from emojiData.emoji
    setNewMessage((prevInput) => prevInput + emojiData.emoji);
    setShowPicker(false); // Hide the emoji picker after selecting an emoji
  };
  // This function checks if a click is outside the emoji picker
  const handleClickOutside = (event) => {
    
    

    if (pickerRef.current && !pickerRef.current.contains(event.target)) {
      setShowPicker(false); // Hide the emoji picker if click is outside
    }
  };

  // Set up event listener to detect clicks outside the emoji picker
  useEffect(() => {
    if (showPicker) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }

    // Clean up event listener on component unmount
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [showPicker]);

  const goToNewMessages = () => {
    if (messagesContainerRef.current) {
      messagesContainerRef.current.scrollTo({
        top: messagesContainerRef.current.scrollHeight,
        behavior: "smooth",
      });
    }
    setUnseenCount(0)
  };
   const [file, setFile] = useState(null);

  // Function to handle file selection
   // Handle file selection
   const handleFileChange = (event) => {
    const selectedFile = event.target.files[0];

    if (selectedFile && (selectedFile.type === 'image/jpeg' || selectedFile.type === 'image/png')) {
      setFile(selectedFile); // Store file in state
    } else {
      alert('Only JPG and PNG files are allowed');
    }
  };
  const handleFileUpload = async () => {

    
    const publicKey = currentChat?.public_key;  // Assuming you're storing public_key
    const client_id = currentChat?.client_id
    if (!file || !publicKey) return;
  
    // Create FormData to send the file and public_key to the server
    const formData = new FormData();
    formData.append('file', file);
    formData.append('public_key', publicKey);
    formData.append('client_id', client_id);
  
    // Upload the file to the server
    const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}/api/chat/upload`, {
      method: 'POST',
      body: formData
    });
  
    const result = await response.json();
    const filePath = result.filePath; // This will be the file path returned by the server
    
    // Emit the file path in the message data
    const messageData = {
      client_id: currentChat?.client_id,
      public_key: currentChat?.public_key,
      msg: filePath, // Instead of message text, this will now be the file path
      type: 'file',  // Indicate that this is a file
      from: currentChat?.pseudonym,
      sent_at: new Date().toISOString(), // Include timestamp when sending message
    };
  
    socket.emit('admin message', messageData);
    setFile(null)
  };
  

  // Handle sending a file through socket
  const handleFileSend = async () => {
    if (!file) return;

    const reader = new FileReader();

    // Convert file to Base64
    reader.onload = function (e) {
      const base64File = e.target.result;

      // Prepare the message data for the file
      const fileData = {
        client_id: currentChat?.client_id,
        public_key: currentChat?.public_key,
        file: base64File, // Sending the file in Base64 format
        fileName: file.name,
        fileType: file.type,
        from: currentChat?.pseudonym,
        sent_at: new Date().toISOString(), // Include timestamp
      };

      // Emit file through socket
      socket.emit('admin file', fileData);
      setFile(null); // Clear file from state after sending
    };

    reader.readAsDataURL(file); // Convert file to Base64
  };

  // Handle message sending 

  return (
    <div className="grid-visitor-container">
      <div className="visitor-box-left">
        <div className="visitor-chat-box chat-box chat-visitor-item-1">
          <div className="visitorChat-header" style={{ padding: "5px" }}>
            <div
              className="d-flex align-items-center justify-content-between w-100"
              style={{ position: "relative" }}
            >
              <span style={{ visibility: "hidden", fontSize: "12px" }}>
                12:30 PM
              </span>
              <span style={{ fontSize: "12px" }}>
                {/* Visitor {currentChat?.chatId} has Joined */}
              </span>
              <span style={{ fontSize: "12px", width: "20%" }}>
                {/* {currentChat?.join_time} */}
              </span>
            </div>
          </div>

          <div
            className="chat-messages"
            ref={messagesContainerRef}
            onScroll={handleScroll}
            style={{ overflowY: "auto", position: "relative" }}
          >
            {isLoadingOldMessages && <div className="loading-spinner"></div>}
            {!hasOldMessages && !isLoadingOldMessages && noMoreOldChats && (
              <button
                onClick={fetchOldMessages}
                className="load-old-messages-button"
              >
                Load Old er Messages
              </button>
            )}

            {unseenCount > 0 && (
              <div
                className="new-message-notification"
                onClick={goToNewMessages}
              >
                New Messages <FaAngleDoubleDown />
              </div>
            )}

{messages
  .slice()
  .reverse()
  .map((message, index) => (
    <React.Fragment key={index}>
      {message.msgtype === "comment" ? (
        <div style={{ textAlign: "center" }}>
          <div className="comment-message" style={{ margin: "10px 0", color: "rgb(159 159 159)" }}>
            <p>{message.msg}</p>
            <small>{convertUtcToLocal(message.sent_at)}</small>
          </div>
        </div>
      ) : (
        <div
          className={`message-bubble ${
            message.type === "admin" && message.from === currentChat?.pseudonym
              ? "admin-message-right" // Admin's own message aligned right
              : message.type === "admin"
              ? "admin-message" // Admin's message aligned left
              : "client-message" // Visitor message aligned left
          }`}
        >
          <span style={{ fontSize: "10px", color: "#888",   }}>
            {message.type === "admin" && message.from === currentChat?.pseudonym
              ? "You"
              : message.type === "admin"
              ? message.from
              : "Visitor"}
          </span>

          {message.msgtype === "file" ? (
            <div className="message-file">
              <img
                src={process.env.NEXT_PUBLIC_API_URL + '/' + message.msg}
                alt="uploaded file"
                style={{ maxWidth: "200px", borderRadius: "5px" }}
              />
            </div>
          ) : (
            <p className="m-0 user-msg">{message.msg}</p>
          )}

          <span style={{ fontSize: "10px", color: "#888" }}>
            {convertUtcToLocal(message.sent_at)}
          </span>
 
          {/* Show tick mark or "Seen" label if the message is seen */}
          {message.is_seen === 1 && message.type =='admin' && (
            <span className="message-seen-tick">✔✔ </span> // Double tick mark or "Seen" label
          )}
        </div>
      )}
    </React.Fragment>
  ))}


            {/* Display typing indicator */}
            {typingUsers.size > 0 && (
              <div className="typing-indicator">
                {Array.from(typingUsers).map((user, index) => (
                  <div key={index} className="typing-user">
                    {user} is typing...
                  </div>
                ))}
              </div>
            )}
          </div>
        </div>
        <div className="panel-input-box chat-visitor-item-2 mt-2">
          <div style={{ placeContent: "flex-end", height: "100%" }}>
            <div>
              <textarea
                className="w-100 border-none"
                cols={4}
                style={{ resize: "none", border: "none" }}
                rows={3}
                value={newMessage}
                onChange={handleInputChange}
                onKeyDown={handleKeyDown}
                placeholder="Type your message..."
                // disabled={currentChat.visitorStatus === 3} // Disable if status is 3
              />
            </div>
            <div
              className="d-flex p-2 border align align-items-center"
              style={{ fontSize: "13px" }}
            >
              <span style={{ flex: 3 }}>Type and press Enter</span>
              <div
                style={{ flex: 3, cursor: "pointer" }}
                className="d-flex justify-content-end"
              >
                {/* Button to show emoji picker */}
                {/* Button to show emoji picker */}
                <span
                  className="px-2 chat-extra-btns  emoji-btn"
                  onClick={() => setShowPicker(!showPicker)}
                >
                  <HiEmojiHappy
                    style={{ marginRight: "1px", fontSize: "15px" }}
                  />
                  <span>Emoji</span>
                </span>

                {/* Emoji picker dropdown */}
                {showPicker && (
                  <div className="emoji-picker-container" ref={pickerRef}>
                    <EmojiPicker
                      width={250}
                      height={300}
                      searchDisabled
                      size={12}
                      lazyLoadEmojis={true}
                      style={{ fontSize: "11px" }}
                      previewConfig={{
                        showPreview: false,
                      }}
                      onEmojiClick={onEmojiClick}
                      pickerStyle={{ position: "absolute", zIndex: 1000 }}
                    />
                  </div>
                )}
                    {/* Conditionally render based on rating state */}
      <span className={`px-2 chat-extra-btns ${chatRating === 3 ? 'no-rating-given' : ''}`}>
        {chatRating === 1 && (
          <>
            <AiFillLike style={{ marginRight: '1px', fontSize: '15px', color: 'green' }} />
            <span style={{color:'green'}}>Rating</span>
          </>
        )}

        {chatRating === 0 && (
          <>
            <AiFillDislike style={{ marginRight: '1px', fontSize: '15px', color: 'red' }} />
            <span style={{color:'red'}}>Rating</span>
          </>
        )}

        {chatRating === 3 && (
          <>
            <AiOutlineLike style={{ marginRight: '1px', fontSize: '15px' }} />
            <span>Rating</span>
          </>
        )}
      </span>

      
                 {/* Button to open file input */}
      <span className="px-2 chat-extra-btns" onClick={() => document.getElementById('fileInput').click()}>
        <IoIosAttach style={{ marginRight: '1px', fontSize: '15px' }} />
        <span>Attach</span>
      </span>

      {/* Hidden file input for selecting image files */}
      <input
        type="file"
        id="fileInput"
        accept=".jpg,.jpeg,.png"
        style={{ display: 'none' }}
        onChange={handleFileChange}
      />

      {/* Show a preview of the selected file (if any) */}
      {file && (
        <div className="file-preview">
          <p>Selected file: {file.name}</p>
          <button onClick={handleFileUpload}>Send File</button>
        </div>
      )}
              </div>
            </div>
          </div>
        </div>
      </div>

      <VisitorDetails
        clientId={currentChat?.client_id}
        setHideColumns={setHideColumns}
        setCurrentChat={setCurrentChat}
        originalJoinTimes={originalJoinTimes}
        publicKey={currentChat?.public_key}
        currentChat={currentChat}
      />
    </div>
  );
};

export default ChatVisitor;
