'use client'
import React, { useEffect, useLayoutEffect, useRef, useState } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import {  closeTab,  toggleMinimizeTab,  updateTabStatus, setBlinkingTab, RemoveBlinkingFromTab, updateTabVisitorSession, updateTabServedBy, updateTabDetails } from '../lib/features/chat/chatSlice';
import './Tabs.css';
import allTones from './data/allTones';
import GlobalChat from './GlobalChat';
 
import { BiSolidMessageRoundedError } from "react-icons/bi";
import { CiCircleChevDown } from "react-icons/ci";

import { CiCircleChevUp } from "react-icons/ci";


import { getSocket } from '../lib/socketManager';
import axios from 'axios';
import apiRequest from '../lib/InterceptorAxios/axios';
import { FaChevronCircleDown, FaChevronCircleUp } from 'react-icons/fa';
import { decryptData } from '../utils/DecryptData';
import { RxCross2 } from 'react-icons/rx';

const Tabs = () => {
  const dispatch = useDispatch();
  const [socket, setSocket] = useState(null);
  const { tabs, activeTab } = useSelector((state) => state.chat);
  const tabsContainerRef = useRef(null);
 const [RightArrow, setRightArrow] = useState(false)
 const [LeftArrow, setLeftArrow] = useState(false)
  const isMouseDown = useRef(false);
  const startX = useRef(0);
  const [alertData, setAlertData] = useState([])
  const [isHiddenOneTime, setisHiddenOneTime] = useState(false);
  const [isHiddenTargetedAlert, setIsHiddenTargetedAlert] = useState(false);
  const scrollLeft = useRef(0);
  const [activeTabContent, setactiveTabContent] = useState(tabs.find((tab) => tab.client_id === activeTab) )
  
  const user = useSelector((state) => state.user.userInfo);
  const sampleDivRef = useRef(null);
  const { newVisitorTone, messageTone, toneStatus } = useSelector(state => state.tones);
const newVisitorToneRef = useRef(null);  // Ref for new visitor tone
const messageToneRef = useRef(null);
const selectedBrands = useSelector((state) => state.selectedBrands.selectedBrands);
  useEffect(() => {
    const container = tabsContainerRef.current;

    const handleMouseDown = (event) => {
      isMouseDown.current = true;
      startX.current = event.pageX - container.offsetLeft;
      scrollLeft.current = container.scrollLeft;
      container.style.cursor = 'grabbing'; // Change cursor style
    };

    const handleMouseLeave = () => {
      isMouseDown.current = false;
      container.style.cursor = 'grab'; // Reset cursor style
    };

    const handleMouseUp = () => {
      isMouseDown.current = false;
      container.style.cursor = 'grab'; // Reset cursor style
    };

    const handleMouseMove = (event) => {
      if (!isMouseDown.current) return; // Exit if not dragging
      event.preventDefault();
      const x = event.pageX - container.offsetLeft;
      const walk = (x - startX.current) * 2; // Scroll-fast (2x speed)
      container.scrollLeft = scrollLeft.current - walk;
    };

    // Add event listeners
    container.addEventListener('mousedown', handleMouseDown);
    container.addEventListener('mouseleave', handleMouseLeave);
    container.addEventListener('mouseup', handleMouseUp);
    container.addEventListener('mousemove', handleMouseMove);

    return () => {
      // Cleanup event listeners
      container.removeEventListener('mousedown', handleMouseDown);
      container.removeEventListener('mouseleave', handleMouseLeave);
      container.removeEventListener('mouseup', handleMouseUp);
      container.removeEventListener('mousemove', handleMouseMove);
    };
  }, []);
  useEffect(() => {
    const container = tabsContainerRef.current;
  
    const handleScroll = () => {
      const containerRect = container.getBoundingClientRect();
      const tabElements = container.children;
      let showLeftArrow = false;
      let showRightArrow = false;
  
      for (let i = 0; i < tabElements.length; i++) {
        const tabRect = tabElements[i].getBoundingClientRect();
        const isBlinking = tabElements[i].classList.contains('blinking');
        
        // Check if the tab is out of the container’s left or right bounds
        if (tabRect.left < containerRect.left && isBlinking) {
          showLeftArrow = true; // Tab is off the right side or has a new message
           
          
        }
        if (tabRect.right > containerRect.right && isBlinking) {
         
          showRightArrow = true; // Tab is off the left side or has a new message
        }
  
        // Stop checking if both arrows are already needed
        if (showLeftArrow && showRightArrow) break;
      }
  
      // Update arrow state based on visibility
      setLeftArrow(showLeftArrow);
      setRightArrow(showRightArrow);
    };
  
    // Attach scroll event listener to check tab visibility
    container.addEventListener('scroll', handleScroll);
  
    // Initial check for arrow visibility
    handleScroll();
  
    return () => {
      container.removeEventListener('scroll', handleScroll);
    };
  }, []);
  
  
  useEffect(() => {
    // Retrieve chat tabs from localStorage
    const storedTabs = JSON.parse(localStorage.getItem('chatTabs')) || [];
  
    // Extract client_id values from the stored tabs
    const clientIds = storedTabs.map(tab => tab.client_id);
   
    const fetchClientStatuses = async () => {
      if (clientIds.length > 0) {
        try {
          const { statuses } = await apiRequest('/api/client/client-status', 'POST', { client_ids: clientIds });
    
          // Update statuses in Redux and localStorage
          statuses.forEach((status) => {
            dispatch(
              updateTabStatus({
                client_id: status.client_id,
                status: status.status,
              })
            );
          });
        } catch (error) {
          console.error('Error updating client status:', error);
        }
      }
    };
    
  
  const fetchAlerts = async () => {
    try {
      const { alert } = await apiRequest('/api/alerts');
  
      if (alert) {
        setAlertData((prevAlerts) => [
          ...prevAlerts,
          { ...alert, isHidden: false }, // Add visibility flag
        ]);
      }
    } catch (error) {
      console.error('Error fetching alerts:', error);
    }
  };
  
    // Call both functions
    fetchClientStatuses();
    fetchAlerts();
  }, [dispatch]);
  
  
  useEffect(() => {
    const socketinst = getSocket();
    if (!socketinst) return;
    setSocket(socketinst);

    const handleVisitorStatusChange = (data) => {
      // console.log("visitor status change")
      // console.log(data)
      const decryptedData = decryptData(data)
      const { client_id, status } = decryptedData;
      // console.log(decryptedData)
      // console.log(client_id);
      // console.log(status);
      
      dispatch(updateTabStatus({ client_id, status }));
    };

    const handleNewMessageBlink = (data) => {
      const message = decryptData(data);
      
      
  
   // If notifyAllAdmins is false, check if userId exists in unseenCounts
   if (!message.notifyAllAdmins && !message.unseenCounts.hasOwnProperty(user.userId)) {
    // 
    return;
}

      
          if (selectedBrands.length === 0 || selectedBrands.includes(message.public_key)) {
              let currentChatVisitorId;
              if (typeof window !== "undefined") {
                  const div = document.querySelector("[class^='grid-visitor-container']");
                  if (div) {
                      const classList = div.className.split(" ");
                      if (classList.length > 1) {
                          currentChatVisitorId = classList[1];
                      }
                  }
              }
              if (currentChatVisitorId != message.client_id) {
                  playNotificationSound(); // Play sound if the chat is not active
              }
          }
      
      // Dispatch blinking action
      dispatch(setBlinkingTab({ client_id: message.client_id }));
  
      const tabIndex = getTabIndex(message.client_id);
      const container = tabsContainerRef.current;
      if (tabIndex !== -1 && message.client_id !== activeTab) {
          const isTabVisible = tabIndex >= 0 && tabIndex < 5; // Adjust based on visible tabs
          const tabElements = container.children;
          const tabElement = tabElements[tabIndex];
  
          if (tabElement) {
              const { left, right } = tabElement.getBoundingClientRect();
              const containerRect = container.getBoundingClientRect();
  
              if (right > containerRect.width) {
                  setRightArrow(true); // Show right indicator
              } else if (left < container.scrollLeft) {
                  setLeftArrow(true); // Show left indicator if needed
              }
          }
      }
  };
  
    
    const handleActiveVisitors = (data) => {
      const decryptedData = decryptData(data)
    const { client_id, public_key, join_time,unseenMsg, served_by, landing_url, os, ip, country, status, visitor_session_id, client_name ,browser,brand_name } = decryptedData 
    
      if(unseenMsg.length>0){
      if (activeTab || activeTab != client_id) {
        dispatch(setBlinkingTab({ client_id: client_id }));
      }

     }
     else{
      
      
      //  dispatch(RemoveBlinkingFromTab(client_id)); // Set the tab as active and stop blinking
     }
     dispatch(updateTabStatus({ client_id, status }));
     dispatch(updateTabVisitorSession({ client_id, visitor_session_id }));
     let servedBy;
     if(served_by){
      servedBy = true;
     }
     else{
      servedBy = false;
     }
     dispatch(updateTabServedBy({ client_id, servedBy }));

     
     };
     const handleNewClient = (data) => {
      const decryptedData = decryptData(data)
      const { client_id, public_key,brand_name, join_time, landing_url, os, ip, country,visitor_session_id, status, browser } = decryptedData;
      
      
      dispatch(updateTabVisitorSession({ client_id, visitor_session_id }));
      dispatch(updateTabStatus({ client_id, status }));
      // dispatch(updateTabDetails())
    
     dispatch(updateTabServedBy({ client_id, servedBy:false }));

     
    
    }
    const handleMessageSeen = (data) => {
      const decryptedData = decryptData(data)
      const message = decryptedData
      if(decryptedData.user_id != user.userId){
        return null;
      }
      
      // Find the corresponding tab and stop the blinking
      dispatch(RemoveBlinkingFromTab(message.client_id)); // Set the tab as active and stop blinking
    };
    
    const handleClientDataUpdate = (data) => {
      const decryptedData = decryptData(data)
      const updatedData = decryptedData;
      const { client_id, name } = updatedData;
        // Update the tab's name in the Redux store
      dispatch(
        updateTabDetails({
          client_id:client_id,
          name:name,
        })
      );
      
    };
    const handleVisitorServedByUpdate = (data) => {
      const decryptedData = decryptData(data)
      const { client_id, served_by } = decryptedData
      let servedBy = true;
      dispatch(updateTabServedBy({ client_id, servedBy }));
    }
   
    
    // Emit brand ID to the backend when the page loads
  socketinst.emit('page load', { brand_id: false });
    socketinst.on('new client', handleNewClient);
    socketinst.on('visitor status change', handleVisitorStatusChange);
    socketinst.on('New message blink', handleNewMessageBlink);
    socketinst.on('message_seen', handleMessageSeen);
    socketinst.on('visitor served by update', handleVisitorServedByUpdate);
    socketinst.on('active visitors', handleActiveVisitors);
     // Listen for the client data updated event
     socketinst.on('client data updated', handleClientDataUpdate);
     // Listen for the `new-alert` event from the socket
     socketinst.on("new-alert", (data) => {
      // Handle the new alert event
      const decryptedData = decryptData(data)
     

      const { msg, alertType } = decryptedData;

      // Add the new alert to the list
      setAlertData((prevAlerts) => [
        ...prevAlerts,
        { msg, alertType, isHidden: false }, // Add visibility flag
      ]);
    });

    return () => {
      socketinst.off('active visitors', handleActiveVisitors);
      socketinst.off('new client', handleNewClient);
      socketinst.off('visitor served by update', handleVisitorServedByUpdate);
      socketinst.off('visitor status change', handleVisitorStatusChange);
      socketinst.off('New message blink', handleNewMessageBlink);
        // Cleanup the socket listener
        socketinst.off('client data updated', handleClientDataUpdate);
      socketinst.off('message_seen', handleMessageSeen);
    };
  }, [selectedBrands]);
  
  useEffect(() => {
    if (toneStatus === 'succeeded') {
      
       messageToneRef.current = messageTone
    }
  }, [toneStatus]);
  useEffect(() => {
    
    if(activeTab && activeTabContent){
      const socketinst = getSocket();
      if (!socketinst) return;
      if(activeTabContent.status != 4  ){
     
        
        
        socketinst.emit('join chat',{
          client_id:activeTabContent.client_id,
          public_key:activeTabContent.public_key,
          realName: user.pseudonym,
          userId: user.userId,
          visitor_session_id:activeTabContent.visitor_session_id
        })
      }
    }
  }, [])
  
  const handleHide = () => setisHiddenOneTime(true);
  const handleShow = () => setIsHiddenTargetedAlert(false);

  // if (!alertData) return null; // No alert to display
 
  const playNotificationSound = () => {
    
    
    const audio = new Audio(`/sounds/${messageToneRef.current.file}`);
    audio.play().catch(err => console.error('Error playing sound:', err));
  };
  const scrollToLeftTab = () => {
    const container = tabsContainerRef.current;
    const tabElements = Array.from(container.children);
    
    
    
    // Find the first blinking or off-screen tab to the left
    for (let i = tabElements.length - 1; i >= 0; i--) {
      const tab = tabElements[i];
      const { left, right } = tab.getBoundingClientRect();
      const containerRect = container.getBoundingClientRect();
      const isBlinking = tab.classList.contains('blinking');
  
      if ((isBlinking && left < containerRect.left) && right < containerRect.right) {
        container.scrollLeft -= containerRect.left - left;
        break;
      }
    }
  };
  
  const scrollToRightTab = () => {
    const container = tabsContainerRef.current;
    const tabElements = Array.from(container.children);
    
    // Find the first blinking or off-screen tab to the right
    for (let i = 0; i < tabElements.length; i++) {
      const tab = tabElements[i];
      const { left, right } = tab.getBoundingClientRect();
      const containerRect = container.getBoundingClientRect();
      const isBlinking = tab.classList.contains('blinking');
  
      if ((isBlinking && right > containerRect.right) && left > containerRect.left) {
        container.scrollLeft += right - containerRect.right;
        break;
      }
    }
  };
  
  const handleTabClick = (client_id,public_key,visitor_session_id,status) => {
   
    
    
    
    
 
      
    if(status != 4 && activeTab != client_id){
     
 
      socket.emit('join chat',{
        client_id,
        public_key,
        pseudonym: user.pseudonym,
        userId: user.userId,
        visitor_session_id
      })
    }
    if(activeTab == client_id){
      socket.emit("stop typing admin", {
        chatKey: `${public_key}_${client_id}`,
        from: user?.pseudonym,
      });
 
      socket.emit('admin_closed_chat',{
        client_id: client_id,
        public_key: public_key,
        realName: user.pseudonym,
        user_id: user.userId
  
      })
    }
    // const { client_id, public_key, realName, userId, visitor_session_id } =
   
    dispatch(toggleMinimizeTab({ client_id }));
  };

  const handleCloseTab = (client_id) => {
    dispatch(closeTab({ client_id }));
  };
  const getTabIndex = (activeTab) => {
    return tabs.findIndex((tab) => tab.client_id === activeTab);
  };

  useEffect(() => {
    const handleWheel = (event) => {
      const container = tabsContainerRef.current;
      if (container) {
        const scrollSpeed = 50;
        container.scrollLeft += event.deltaY > 0 ? scrollSpeed : -scrollSpeed;
      }
    };
  
    const container = tabsContainerRef.current;
    if (container) {
      container.addEventListener('wheel', handleWheel);
    }
  
    return () => {
      if (container) {
        container.removeEventListener('wheel', handleWheel);
      }
    };
  }, []);
  
 
useLayoutEffect(() => {

  
  setactiveTabContent(tabs.find((tab) => tab.client_id === activeTab))
}, [activeTab])
const handleHideAlert = (index) => {
  setAlertData((prevAlerts) =>
    prevAlerts.filter((alert, i) =>
      i === index && alert.alertType === "one-time" ? false : true
    ).map((alert, i) =>
      i === index && alert.alertType !== "one-time" ? { ...alert, isHidden: true } : alert
    )
  );
};


const handleShowAlert = (index) => {
  setAlertData((prevAlerts) =>
    prevAlerts.map((alert, i) =>
      i === index ? { ...alert, isHidden: false } : alert
    )
  );
};
const hasOneTimeAlert = alertData.some(alert => alert.alertType === "one-time");


  return (
    <>
    <div>
      {alertData.map((alert, index) => (
        <div key={index}>
          {!alert.isHidden && alert.alertType === "one-time" && (
            <div className="alert-by-admin">
              <span>{alert.msg}</span>
              <button
                className="alert-dismiss-button"
                onClick={() => handleHideAlert(index)}
              >
                &times;
              </button>
            </div>
          )}
          { alert.alertType === "targeted" && (
            <div className={`alert-by-admin ${alert.isHidden ? "hide" : "show"}`}>
              <span>{alert.msg}</span>
              {!alert.isHidden && (
                <FaChevronCircleUp
                  size={20}
                  // className="alert-hide-button"
                  className={`alert-hide-button ${alert.isHidden ? "hide" : "show"}  ${hasOneTimeAlert ?"targeted-none":"no-class"}`}
                  onClick={() => handleHideAlert(index)}
                />
              )}
              {alert.isHidden && (
                <FaChevronCircleDown
                  size={20}
                  // className="alert-show-button"
                  className={`alert-show-button ${alert.isHidden ? "show" : "hide"}`}
                  onClick={() => handleShowAlert(index)}
                />
              )}
            </div>
          )}
        </div>
      ))}
    </div>
  
      <div className="tabs-container">
      <div ref={sampleDivRef} className='audio-play-sample' style={{display:"none"}}></div>
      <div className='tabs-arrows-left-right'>
      {LeftArrow && (
        <BubbleButton
        direction="left"
        icon={<BiSolidMessageRoundedError size={24} />}
        onClick={scrollToLeftTab} // Move onClick here
        />
      )}
  {RightArrow && (
    <BubbleButton
    direction="right"
    icon={<BiSolidMessageRoundedError size={24} />}
    onClick={scrollToRightTab} // Move onClick here
    />
  )}
    </div>
        <div className="tabs-header" ref={tabsContainerRef}>
          {tabs.map((tab) => (
            <div key={tab.client_id}   className={`tab currentone ${tab.blinking ? 'blinking' : ''}  ${activeTab == tab.client_id ? 'visitor-active-tab':''}  `}>
          {/* tab rings  */}
          
          <div className={`tab-ring  ${activeTab === tab.client_id && !tab.minimized ? 'active' : ''}  ${tab.visitorStatus==2?'visitor-idle':''} ${!tab.servedBy && 'visitor-not-served'}  ${tab.visitorStatus==1?' active-visitor-tab':''} ${tab.visitorStatus==4?'visitor-left':''}  ${tab.visitorStatus==5?'visitor-non-active':''}     ${tab.visitorStatus==3?'visitor-close-chat':''}`}>
            </div>
               <button
                className={`tab-button  ${tab.blinking ? 'blinking' : ''}  `}
                onClick={() => handleTabClick(tab.client_id,tab.public_key,tab.visitor_session_id,tab.visitorStatus)}
              >
                {/* ${tab.client_id.slice(0, 5)}... */}
                {` ${tab.name ? (tab.name.length > 13 ? tab.name.slice(0, 13) + '..' : tab.name) : ''+ tab.client_id.slice(0, 5)} `}
              </button>
              <button className="close-tab" onClick={() => handleCloseTab(tab.client_id)}>
              <RxCross2 size={15} />

              </button>
            </div>
          ))}
        </div>
      </div>

      {activeTab !== null && activeTabContent && !activeTabContent.minimized && (

        <div className="tab-content">
           
          <GlobalChat currentChat={activeTabContent} />
        </div>
      )}
    </>
  );
};

export default Tabs; 
const BubbleButton = ({ direction, icon, onClick }) => (
  <div className={`bubble-container bubble-${direction}`}>
    <button className="bubble-button" onClick={onClick}>
      {icon}
      {[...Array(10)].map((_, i) => (
        <span
          key={i}
          className="bubble"
          style={{
            top: `${Math.random() * 100}%`,
            left: `${Math.random() * 100}%`,
            animationDelay: `${Math.random() * 2}s`,
          }}
        ></span>
      ))}
    </button>
  </div>
);
 