import React, { useState, useEffect, useRef } from "react";
 
import { HiEmojiHappy } from "react-icons/hi";
import { AiFillDislike, AiFillLike, AiOutlineLike } from "react-icons/ai";
import { IoIosAttach } from "react-icons/io";
import { getSocket } from "@/app/lib/socketManager";
import { IoIosPeople } from "react-icons/io";
import { FaUserShield } from "react-icons/fa";

 
import { FaAngleDoubleDown } from "react-icons/fa";
import { useSelector } from "react-redux";
import VisitorMeta from "./VisitorMeta";
import { FaCheckDouble } from "react-icons/fa6";
import MessageFile from "./MessageFile";
import dynamic from "next/dynamic";
import apiRequest from "../lib/InterceptorAxios/axios";
import MessageWithLink from "./components/MessageWithLink";
import CopyToClipboard from "./components/Alert";
import Alert from "./components/Alert";
import ResizableTypingArea from "../Components/Home/ResizableTypingArea";
import { decryptData } from "../utils/DecryptData";
const GlobalChat = ({ currentChat }) => {
  const socket = getSocket();
  const [messages, setMessages] = useState([]);
  // const [newMessage, setNewMessage] = useState("");
  const newMessageRef = useRef(""); 
  const [userIsScrolledUp, setUserIsScrolledUp] = useState(false);
  const messagesContainerRef = useRef(null);
  const isUserAtBottom = useRef(true);
  const textareaRef = useRef(null);
  const [typingUsers, setTypingUsers] = useState(new Set());
  const [AdmintypingUsers, setAdminTypingUsers] = useState(new Set());
  const lastSeenMessageId = useRef(null); // Store the last seen message ID
  const [lastMessageId, setlastMessageId] = useState(null);
  const [isLoadingOldMessages, setIsLoadingOldMessages] = useState(false);
  const [isOldChat, setisOldChat] = useState(false);
  const [unseenCount, setUnseenCount] = useState();
  const [hasOldMessages, setHasOldMessages] = useState(false);
  const [previousScrollHeight, setPreviousScrollHeight] = useState(0);
  const [isAtBottom, setIsAtBottom] = useState(true);
  const [noMoreOldChats, setnoMoreOldChats] = useState(true);
  const [showPicker, setShowPicker] = useState(false);
  const [chatRating, setchatRating] = useState(3);
  const [isClientSeenMsg, setisClientSeenMsg] = useState();
const [ShowAlert, setShowAlert] = useState(false)
const suggestionlist = useSelector((state) => state.shortcuts.shortcuts);

  
  const visitorRef = useRef(null);
  const user = useSelector((state) => state.user.userInfo);
  const [TabDetail, setTabDetail] = useState([])
  const { tabs, activeTab } = useSelector((state) => state.chat);
  // const currentChatKey = `${currentChat?.public_key}_${currentChat?.client_id}`;
  // const [currentChatKey, setcurrentChatKey] = useState()
  // Dynamically import EmojiPicker
  const EmojiPicker = dynamic(() => import("emoji-picker-react"), {
    ssr: false, // Ensure that it's not rendered on the server side
  });

  useEffect(() => {
    setTypingUsers(new Set());
    setAdminTypingUsers(new Set())
    
  
    
    if ( textareaRef.current) {
      textareaRef.current.focus();
    }
  }, [currentChat.client_id]);
  const typingAreaRef = useRef(null);
  const startYRef = useRef(0); // Track the starting Y position
  const startHeightRef = useRef(0); // Track the starting height
  const [isResizing, setIsResizing] = useState(false);

  // const startResizing = (e) => {
  //   if (e.button !== 0) return; // Allow only left-click to start resizing

  //   setIsResizing(true);
  //   startYRef.current = e.clientY; // Record initial Y position

  //   // Use getBoundingClientRect for more accurate height
  //   const rect = typingAreaRef.current.getBoundingClientRect();
  //   startHeightRef.current = rect.height;

  //   // Disable text selection while resizing
  //   document.body.style.userSelect = "none";

  //   // Attach event listeners for resizing
  //   document.addEventListener("mousemove", handleResizing);
  //   document.addEventListener("mouseup", stopResizing);
  // };

  const handleResizing = (e) => {
    if (!isResizing) return;

    // Calculate the new height dynamically
    const deltaY = e.clientY - startYRef.current; // Difference in Y position
    const newHeight = Math.max(startHeightRef.current - deltaY, 50); // Prevent height from going too small

    // Apply the new height to the element
    typingAreaRef.current.style.height = `${newHeight}px`;
  };

  const stopResizing = () => {
    if (!isResizing) return;

    setIsResizing(false);

    // Enable text selection after resizing
    document.body.style.userSelect = "";

    // Cleanup event listeners
    document.removeEventListener("mousemove", handleResizing);
    document.removeEventListener("mouseup", stopResizing);
  };



  const TabDetailRef = useRef(null);
  useEffect(() => {
    TabDetailRef.current = TabDetail; // Sync ref with state
  }, [TabDetail]);
  
  useEffect(() => {
    const tab = tabs.find((tab) => tab.client_id === activeTab);
  
    if (tab) {
      setTabDetail(tab); // Update TabDetail
    
    } else {
    
    }
  }, [currentChat.client_id, activeTab]);
  
 
  
  const getTab = (activeTab) => {
    return ;
  };

  useEffect(() => {
    const stopTyping = () => {
      if (currentChat.client_id) {
        socket.emit("stop typing admin", {
          chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
          from: user?.pseudonym,
        });
      }
    };

    // Add event listeners for page unload and before unload
    window.addEventListener("beforeunload", stopTyping);
    
    window.addEventListener("unload", stopTyping);

    // Cleanup: Remove event listeners when the component unmounts
    return () => {
      stopTyping(); // Call stopTyping before component unmount
      window.removeEventListener("beforeunload", stopTyping);
      window.removeEventListener("unload", stopTyping);
    };
  }, [currentChat]);

  const pickerRef = useRef(null); // Reference for the emoji picker
  // Fetch chat history when the component mounts
  useEffect(() => {
    setIsAtBottom(true);
    if (true) {
      messagesContainerRef.current.scrollTop =
        messagesContainerRef.current.scrollHeight;
    }
    newMessageRef.current = "";

    setHasOldMessages(false);
    setPreviousScrollHeight(0);
    fetchChatHistory();
  }, [currentChat.client_id]);
  const fetchChatHistory = async (lastMessageId = null, isOldChat = false) => {
    setIsLoadingOldMessages(true);
    try {
      const data = await apiRequest("/api/chat/messages", "POST", {
        chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
        lastMessageId,
        isOldChat,
      });

      if (data.messages) {
        if (isOldChat) {
          setMessages((prevMessages) => [...prevMessages, ...data.messages]);
          setHasOldMessages(data.messages.length > 0); // Check if old messages exist
          setnoMoreOldChats(data.oldChat);
        } else {
          
          setMessages(data.messages);
          messagesContainerRef.current.scrollTop =
            messagesContainerRef.current.scrollHeight;
          messagesContainerRef.scrollTop = messagesContainerRef.scrollHeight;
        }
        // Find the last admin message and check if it's seen by the client
        // Check if the first message is of type 'admin' and is_seen is 1
        if (
          data.messages[0].type === "admin" &&
          data.messages[0].is_seen === 1
        ) {
          setisClientSeenMsg(true); // Set seen flag if the first message is seen
        } else {
          setisClientSeenMsg(false);
        }

        // Scroll to the bottom if user is at the bottom
        if (isUserAtBottom.current) {
          // messagesContainerRef.current.scrollTop = messagesContainerRef.current.scrollHeight;
        }
        // messagesContainerRef.current.scrollTop = messagesContainerRef.current.scrollHeight;
      }
    } catch (error) {
      console.error("Error fetching chat history:", error);
    } finally {
      setIsLoadingOldMessages(false);
    }
  };

  function convertUtcToLocal(utcTimestamp, locale = "en-US") {
    const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
    const date = new Date(utcTimestamp);

    const now = new Date();

    // Create local copies of today and yesterday's start
    const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
    const yesterday = new Date(today);
    yesterday.setDate(today.getDate() - 1);

    // Formatting options
    const timeOptions = {
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      timeZone,
    };
    const dateOptions = {
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      timeZone,
    };

    // Check if the timestamp is from today
    if (date >= today) {
      return `Today ${date.toLocaleTimeString(locale, timeOptions)}`;
    }

    // Check if the timestamp is from yesterday
    if (date >= yesterday && date < today) {
      return `Yesterday ${date.toLocaleTimeString(locale, timeOptions)}`;
    }

    // For timestamps older than yesterday, return date + time
    return `${date.toLocaleDateString(
      locale,
      dateOptions
    )} ${date.toLocaleTimeString(locale, timeOptions)}`;
  }
  // Socket listeners for new messages and typing indicators
  useEffect(() => {
    socket.on("chat message", (data) => {
      // const data = decryptData(encryptedData)
      const message = data
      console.log(data);
      
      const room = `${currentChat?.public_key}_${currentChat?.client_id}`;
      console.log(room);
      
      if (message.room === room) {
        setMessages((prevMessages) => [message, ...prevMessages]);
      }
    });  socket.on("visitor_already_left", (data) => {
      const decryptedData =  decryptData(data)
        const {client_id, msg} = decryptedData
        if (currentChat.client_id === client_id) {
          customOnClick();
        }

      });  
      socket.on("Logged_in_to_other_device", (data) => {
        const closeBtn = document.querySelector('.closed-chatbox-sidebar');
        if (closeBtn) {
            closeBtn.click();
        } else {
           
        }
    
      }); 
    socket.on("visitor status change", (data) => {
      const decryptedData = decryptData(data)
      const { client_id, status, visitor_id } = decryptedData
      if (currentChat.client_id === client_id) {
      
    
        if (TabDetailRef.current && TabDetailRef.current.visitor_session_id === visitor_id) {
        
    
          setTabDetail((prevTab) => ({
            ...prevTab,
            visitorStatus: status,
          }));
        }
      }
    });
    socket.on("chat rating", (data) => {
      
      
      const decryptedData = decryptData(data)
      
      const ratingData = decryptedData;
      if (currentChat.client_id == ratingData.client_id) {
        setchatRating(ratingData.rating);
      }
    });
    socket.on("rating submit by client", (data) => {
       
      const decryptedData = decryptData(data)
      const ratingData = decryptedData;
      if (currentChat.client_id == ratingData.client_id) {
        setchatRating(ratingData.rating);
      }
    });

    socket.on("message_seen by client", (encryptedData) => {
      const data = decryptData(encryptedData)
      if (currentChat.client_id == data.client_id) {
        // Update the message state to reflect the seen status for the correct message
        setMessages((prevMessages) =>
          prevMessages.map((message) =>
            message.messageId == data.message_id
              ? { ...message, is_seen: 1 } // Update the specific message to seen
              : message
          )
        );
      }
    }); // Define the current chat key format

    // Listen for typing start events
    socket.on("typing", (data) => {
      // const data = decryptData(encryptedData)
      // const currentChatKey =`${currentChat?.public_key}_${currentChat?.client_id}`
      let currentClient;

      if (visitorRef.current) {
        const classList = visitorRef.current.className.split(" ");

        currentClient = classList[1];
      }
      let currentChatKey = `${currentChat?.public_key}_${currentClient}`;
      if (data.chatKey === currentChatKey) {
                        setAdminTypingUsers((prevTypingUsers) => {
          const updatedTypingUsers = new Set(prevTypingUsers);
          updatedTypingUsers.add(data.name);
          return updatedTypingUsers;
        });
      }
    });

    // Listen for typing stop events
    socket.on("stop typing", (data) => {
      // const data = decryptData(encryptedData)
      // const currentChatKey =`${currentChat?.public_key}_${currentChat?.client_id}`
      let currentClient;

      if (visitorRef.current) {
        const classList = visitorRef.current.className.split(" ");

        currentClient = classList[1];
      }
      let currentChatKey = `${currentChat?.public_key}_${currentClient}`;
      if (data.chatKey === currentChatKey) {
        setAdminTypingUsers((prevTypingUsers) => {
          const updatedTypingUsers = new Set(prevTypingUsers);
          updatedTypingUsers.delete(data.name);
          return updatedTypingUsers;
        });
      }
    });

   // Listen for "displayTyping" event
socket.on("displayTyping", (encryptedData) => {
  const data = decryptData(encryptedData)
 const  { client_id, chatKey, text } = data
  let currentClient;

  if (visitorRef.current) {
    const classList = visitorRef.current.className.split(" ");
    currentClient = classList[1];
  }

  const currentChatKey = `${currentChat?.public_key}_${currentClient}`;
  if (chatKey === currentChatKey) {
    const typingUserId = `visitor_${client_id}`;
    setTypingUsers((prevTypingUsers) => {
      const updatedTypingUsers = new Map(prevTypingUsers);
      updatedTypingUsers.set(typingUserId, text || "Typing...");
      return updatedTypingUsers;
    });
    showTypingIndicator(typingUserId, text);
  }
});

// Listen for "updateTypingText" event
socket.on("updateTypingText", (encryptedData) => {
  const data = decryptData(encryptedData)
  const  { client_id, chatKey, text } = data
  let currentClient;

  if (visitorRef.current) {
    const classList = visitorRef.current.className.split(" ");
    currentClient = classList[1];
  }

  const currentChatKey = `${currentChat?.public_key}_${currentClient}`;
  if (chatKey === currentChatKey) {
    const typingUserId = `visitor_${client_id}`;
    setTypingUsers((prevTypingUsers) => {
      const updatedTypingUsers = new Map(prevTypingUsers);
      updatedTypingUsers.set(typingUserId, text);
      return updatedTypingUsers;
    });
    updateTypingIndicator(typingUserId, text);
  }
});
const updateTypingIndicator = (typingUserId, text) => {
  const typingElement = document.getElementById(typingUserId);
  if (typingElement) {
    typingElement.innerText = text || "Typing...";
  }
};

// Listen for "hideTyping" event
socket.on("hideTyping", (encryptedData) => {
  const data = decryptData(encryptedData)
  const { client_id, chatKey } = data
  let currentClient;

  if (visitorRef.current) {
    const classList = visitorRef.current.className.split(" ");
    currentClient = classList[1];
  }

  const currentChatKey = `${currentChat?.public_key}_${currentClient}`;
  if (chatKey === currentChatKey) {
    const typingUserId = `visitor_${client_id}`;
    setTypingUsers((prevTypingUsers) => {
      const updatedTypingUsers = new Map(prevTypingUsers);
      updatedTypingUsers.delete(typingUserId);
      return updatedTypingUsers;
    });
    hideTypingIndicator(typingUserId);
  }
});

    // Helper functions to manage typing indicators
    function showTypingIndicator(typingUserId) {
      if (typingUserId.startsWith("visitor_")) {
      } else {
      }
    }

    function hideTypingIndicator(typingUserId) {
      if (typingUserId.startsWith("visitor_")) {
      } else {
      }
    }

    socket.on("chat history", (data) => {});

    return () => {
      socket.off("chat message");
      socket.off("typing");
      socket.off("stop typing");
    };
  }, [currentChat.client_id]);
  const checkIfAtBottom = () => {
    const container = messagesContainerRef.current;
    if (container) {
      const isUserAtBottom =
        Math.abs(
          container.scrollHeight - container.scrollTop - container.clientHeight
        ) <= 2;
      setIsAtBottom(isUserAtBottom);

      return isUserAtBottom;
    }
  };

  useEffect(() => {
    const container = messagesContainerRef.current;
    const hasScrollBar = container.scrollHeight > container.clientHeight;
    const scrollableHeight = container.scrollHeight;
    const scrollPosition = container.scrollTop;
    const visibleHeight = container.clientHeight;

    // Distance from the bottom
    const distanceFromBottom =
      scrollableHeight - (scrollPosition + visibleHeight);

    // Get the current scroll position from the top
    const distanceFromTop = container.scrollTop;

    if (hasScrollBar && isAtBottom) {
      messagesContainerRef.current.scrollTop =
        messagesContainerRef.current.scrollHeight;
    }
    if (isAtBottom && messages.length > 0) {
      const latestMessage = messages[0];

      if (
        (activeTab && latestMessage.from !== user.pseudonym) ||
        latestMessage.msgtype === "comment"
      ) {
        socket.emit("is_chat_seen", {
          chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
          client_id: currentChat?.client_id,
          public_key: currentChat?.public_key,
          isSeen: 1,
          user_id:user.userId,
        });
        lastSeenMessageId.current = latestMessage.messageId;
        setUnseenCount(0); // Reset unseen count once messages are seen
      }
    } else if (container && isAtBottom) {
      container.scrollTop = container.scrollHeight; // Scroll to the bottom
    }
    socket.on("chat message", (message) => {
      // const data = decryptData(encryptedData)
      // const message = data
      setisClientSeenMsg(false);

      if (message.from == currentChat.client_id) {
        setUnseenCount((prev) => prev + 1); // Increment unseen count
      }
    });
  }, [messages, currentChat, isClientSeenMsg]);

  const handleScroll = () => {
    const container = messagesContainerRef.current;

    const isAtBottom = checkIfAtBottom();

    if (container) {
      const scrollableHeight = container.scrollHeight;
      const scrollPosition = container.scrollTop;
      const visibleHeight = container.clientHeight;

      // Distance from the bottom
      const distanceFromBottom =
        scrollableHeight - (scrollPosition + visibleHeight);

      // Get the current scroll position from the top
      const distanceFromTop = container.scrollTop;

      if (isAtBottom && messages.length > 0) {
        const latestMessage = messages[messages.length - 1];
        if (currentChat && latestMessage.from !== user.pseudonym) {
          
          socket.emit("is_chat_seen", {
            chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
            client_id: currentChat?.client_id,
            public_key: currentChat?.public_key,
            isSeen: 1,
            user_id:user.userId,
          });
          lastSeenMessageId.current = latestMessage.messageId;
          setUnseenCount(0); // Reset unseen count once messages are seen
        }
      }

      // Detect when the user scrolls to the top to fetch older messages
      if (container.scrollTop === 0 && messages.length > 0 && hasOldMessages) {
        setIsLoadingOldMessages(true);
        const messagelength = messages.length;
        const firstMessageId = messages[messagelength - 1].messageId; // First message ID
        setPreviousScrollHeight(container.scrollHeight); // Save the previous scroll height

        if (noMoreOldChats) {
          fetchChatHistory(firstMessageId, true).then(() => {
            // After fetching, adjust scroll position
            const newHeight = container.scrollHeight; // New height after loading messages
            const scrollOffset = newHeight - previousScrollHeight; // Calculate the offset
            container.scrollTop = scrollOffset; // Adjust scroll position
            setIsLoadingOldMessages(false);
          });
        }
      }
    }
  };

  // Add a useEffect to handle showing the notification icon
  useEffect(() => {
    if (unseenCount > 0) {
 
    }
  }, [unseenCount]);

  // Add an event listener for scroll
  useEffect(() => {
    const container = messagesContainerRef.current;
    if (container) {
      container.addEventListener("scroll", handleScroll);
      return () => container.removeEventListener("scroll", handleScroll);
    }
  }, []);

  const handleSendMessage = () => {
    setisClientSeenMsg(false);
    socket.emit("stop typing admin", {
      chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
      from: user?.pseudonym,
    });
    if (newMessageRef.current.trim() === "") return;
    const timeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;

    const messageData = {
      client_id: currentChat?.client_id,
      public_key: currentChat?.public_key,
      msg: newMessageRef.current,
      from: user?.pseudonym,
      sent_at: new Date().toISOString(), // Include timestamp when sending message
      type: "chat",
    };

    socket.emit("admin message", messageData);
    newMessageRef.current = "";
  };
 
  const [suggestions, setSuggestions] = useState([]);
  const [filteredSuggestions, setFilteredSuggestions] = useState([]);
  const [isSuggestionVisible, setIsSuggestionVisible] = useState(false);
   //uncomment in v2 later
//    useEffect(() => {
//     // Safely format suggestionlist elements
//     const filteredShortcuts = shortcuts.filter(s =>
//       s.text.toLowerCase().includes(input.toLowerCase())
//     );
//     const formattedShortcuts = suggestionlist.flatMap(shortcut => {
//         // Ensure each element is an array before calling join
//         return Array.isArray(shortcut) ? shortcut.join(' ') : shortcut;
//     });
//     
//     setSuggestions(filteredShortcuts);
// }, [suggestionlist]);


// useEffect(() => {
//   setSuggestions(suggestionlist)
// }, []);


  // const handleKeyDown = (event) => {
  //   if (event.key === "Enter" && !event.shiftKey) {
  //     event.preventDefault();
  //     handleSendMessage();
  //   }
  // };
 // Handles the input change in the textarea
 const [selectedSuggestionIndex, setSelectedSuggestionIndex] = useState(0);
 const [suggestionPosition, setSuggestionPosition] = useState({ top: 0, left: 0 });
//  const textareaRef = useRef(null);
 const hiddenSpanRef = useRef(null);
// /const suggestionlist = useSelector((state) => state.shortcuts.shortcuts);

const selectSuggestion = (suggestion) => {
  // Get the current message
  const currentMessage = newMessageRef.current;

  // Use regex to find the last word and replace it with the selected suggestion text
  const updatedMessage = currentMessage.replace(/\b\S+$/, suggestion.text);

  // Update the reference with the new message
  newMessageRef.current = updatedMessage;

  // Update the UI (clear suggestions)
  setFilteredSuggestions([]);
  setIsSuggestionVisible(false);
};

// Update the position of the suggestion dropdown
const updateSuggestionPosition = () => {
  if (textareaRef.current && hiddenSpanRef.current) {
    const textarea = textareaRef.current;
    const hiddenSpan = hiddenSpanRef.current;

    // Set the hidden span's content to match the textarea's content
    hiddenSpan.textContent = textarea.value.substring(0, textarea.selectionStart);

    // Get the bounding rectangle of the hidden span to position the suggestion
    const { offsetLeft, offsetTop } = textarea;
    const { offsetWidth, offsetHeight } = hiddenSpan;

    setSuggestionPosition({
      top: 10, // Adjust the vertical offset as needed
      left: offsetLeft + offsetWidth,
    });
  }
};

const handleInputChange = (event) => {
  const inputValue = event.target.value;

  // Prevent unintended cursor resets
  event.preventDefault();

  // Update the reference and state
  newMessageRef.current = inputValue;

  // Emit typing events (optional feature for live typing)
  if (inputValue.trim()) {
    socket.emit("typing admin", {
      chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
      from: user?.pseudonym,
    });
  } else {
    socket.emit("stop typing admin", {
      chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`,
      from: user?.pseudonym,
    });
  }

  // Calculate cursor position for suggestions
  updateSuggestionPosition();

  // Split input value to get the last word typed
  const words = inputValue.split(/\s+/); // Split by spaces
  const lastWord = words[words.length - 1];

  // Filter suggestions based on the last word typed
  if (lastWord) {
    const filtered = suggestionlist.filter((shortcut) =>
      shortcut.text.toLowerCase().startsWith(lastWord.toLowerCase())
    );

    // Update the suggestions state
    setFilteredSuggestions(filtered);
    setIsSuggestionVisible(filtered.length > 0);
  } else {
    setFilteredSuggestions([]);
    setIsSuggestionVisible(false);
  }
};

useEffect(() => {
  // Log suggestion list when it updates (for debugging purposes)
  

  // Safely format shortcut list elements to filter based on input
  const filteredShortcuts = suggestionlist.filter((s) =>
    s.text.toLowerCase()
  );

  setSuggestions(filteredShortcuts);

}, [suggestionlist]);



// Handles the keydown event for navigation and selection
const handleKeyDown = (event) => {

  if (isSuggestionVisible) {
    if (event.key === 'ArrowDown') {
      // Move selection down
      event.preventDefault();
      setSelectedSuggestionIndex((prevIndex) =>
        prevIndex < filteredSuggestions.length - 1 ? prevIndex + 1 : prevIndex
      );
      event.preventDefault();
    } else if (event.key === 'ArrowUp') {
      // Move selection up
      event.preventDefault();
      setSelectedSuggestionIndex((prevIndex) =>
        prevIndex > 0 ? prevIndex - 1 : 0
      );
      event.preventDefault();
    } else if (event.key === 'Enter') {
      // Select the highlighted suggestion
            event.preventDefault();
            setSelectedSuggestionIndex(0)
      selectSuggestion(filteredSuggestions[selectedSuggestionIndex]);
      event.preventDefault();
    }else if (event.key === 'ArrowRight') {
      // Select the highlighted suggestion
      event.preventDefault();
      selectSuggestion(filteredSuggestions[selectedSuggestionIndex]);
      setSelectedSuggestionIndex(0)
      event.preventDefault();
    } else if (event.key === 'Escape') {
      // Close the suggestions list
      event.preventDefault();
      setSelectedSuggestionIndex(0)
      setIsSuggestionVisible(false);
    }
  }
  else{
       if (event.key === "Enter" && !event.shiftKey) {
      event.preventDefault();
      setSelectedSuggestionIndex(0)
      handleSendMessage();
    }
  }
};
 
 
   
 
  

  useEffect(() => {
    if (!userIsScrolledUp) {
      isUserAtBottom.current = true;
    }
  }, [  isClientSeenMsg]);
  const fetchOldMessages = () => {
    setHasOldMessages(true);
    const messagesLength = messages.length;
    const firstMessageId = messages[messagesLength - 1].messageId;
    const container = messagesContainerRef.current;

    // Save the previous scroll height before fetching new messages
    const previousScrollHeight = container.scrollHeight;

    // Fetch chat history
    fetchChatHistory(firstMessageId, true).then(() => {
      // Use requestAnimationFrame to ensure the DOM has updated before recalculating scroll position
      requestAnimationFrame(() => {
        const newHeight = container.scrollHeight; // Get the new height after loading messages
        setPreviousScrollHeight(newHeight);
        const scrollOffset = newHeight - previousScrollHeight; // Calculate the difference
        container.scrollTop = scrollOffset; // Adjust scroll position

        // Stop loading indicator for old messages
        setIsLoadingOldMessages(false);
      });
    });
  };
  // Function to handle when an emoji is clicked
  const onEmojiClick = (emojiData) => {
    // Access the selected emoji from emojiData.emoji
    // setNewMessage((prevInput) => prevInput + emojiData.emoji);
    newMessageRef.current = newMessageRef.current + emojiData.emoji;
    setShowPicker(false); // Hide the emoji picker after selecting an emoji
  };
  // This function checks if a click is outside the emoji picker
  const handleClickOutside = (event) => {
    if (pickerRef.current && !pickerRef.current.contains(event.target)) {
      setShowPicker(false); // Hide the emoji picker if click is outside
    }
  };

  // Set up event listener to detect clicks outside the emoji picker
  useEffect(() => {
    if (showPicker) {
      document.addEventListener("mousedown", handleClickOutside);
    } else {
      document.removeEventListener("mousedown", handleClickOutside);
    }

    // Clean up event listener on component unmount
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [showPicker]);

  const goToNewMessages = () => {
    if (messagesContainerRef.current) {
      messagesContainerRef.current.scrollTo({
        top: messagesContainerRef.current.scrollHeight,
        behavior: "smooth",
      });
    }
    setUnseenCount(0);
  };
  const [file, setFile] = useState(null);

  // Function to handle file selection
  // Handle file selection
  const handleFileChange = (event) => {
    const selectedFile = event.target.files[0];

    if (
      selectedFile &&
      (selectedFile.type === "image/jpeg" || selectedFile.type === "image/png")
    ) {
      setFile(selectedFile); // Store file in state
    } else {
      alert("Only JPG and PNG files are allowed");
    }
  };
  const handleFileUpload = async () => {
    const publicKey = currentChat?.public_key; // Assuming you're storing public_key
    const client_id = currentChat?.client_id;
  
    if (!file || !publicKey) return;
  
    // Create FormData to send the file and other data to the server
    const formData = new FormData();
    formData.append("file", file);
    formData.append("public_key", publicKey);
    formData.append("client_id", client_id);
 
    
      // Send the request using fetch
      const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL3}/api/chat/upload`, {
        method: "POST",
        body: formData, // No need to stringify FormData
      });
  
      if (!response.ok) {
        console.error(`File upload failed with status: ${response.status}`);
      }
  
      const result = await response.json();
    const filePath = result.filePath; // This will be the file path returned by the server

    // Emit the file path in the message data
    const messageData = {
      client_id: currentChat?.client_id,
      public_key: currentChat?.public_key,
      msg: filePath, // Instead of message text, this will now be the file path
      type: "file", // Indicate that this is a file
      from: user?.pseudonym,
      sent_at: new Date().toISOString(), // Include timestamp when sending message
    };

    socket.emit("admin message", messageData);
    setFile(null);
  };

  // Handle sending a file through socket
  const handleFileSend = async () => {
    if (!file) return;

    const reader = new FileReader();

    // Convert file to Base64
    reader.onload = function (e) {
      const base64File = e.target.result;

      // Prepare the message data for the file
      const fileData = {
        client_id: currentChat?.client_id,
        public_key: currentChat?.public_key,
        file: base64File, // Sending the file in Base64 format
        fileName: file.name,
        fileType: file.type,
        from: user?.pseudonym,
        sent_at: new Date().toISOString(), // Include timestamp
      };

      // Emit file through socket
      socket.emit("admin file", fileData);
      setFile(null); // Clear file from state after sending
    };

    reader.readAsDataURL(file); // Convert file to Base64
  };

  // Handle message sending
  const customOnClick = () => {
    setShowAlert(true)
    setTimeout(() => {
      setShowAlert(false)
    }, 3000);
  };
  return (
    <>
  
    {
      ShowAlert &&
      <Alert toastMessage="Visitor may have left the chat " /> 

    }
     
    <div
      ref={visitorRef}
      className={`grid-visitor-container ${currentChat.client_id}`}
    >
     
      
        
    
      <div className="visitor-box-left">
        <div className="visitor-chat-box chat-box chat-visitor-item-1">
          <div className="visitorChat-header" style={{ padding: "5px" }}>
            <div
              className="d-flex align-items-center justify-content-between w-100"
              style={{ position: "relative" }}
            >
              <span style={{ visibility: "hidden", fontSize: "12px" }}>
                12:30 PM
              </span>
              <span style={{ fontSize: "12px" }}>
                {/* Visitor {currentChat?.chatId} has Joined */}
              </span>
              <span style={{ fontSize: "12px", width: "20%" }}>
                {/* {currentChat?.join_time} */}
              </span>
            </div>
          </div>

          <div
            className="chat-messages"
            ref={messagesContainerRef}
            onScroll={handleScroll}
            style={{ overflowY: "auto", position: "relative" }}
          >
            {isLoadingOldMessages && <div className="loading-spinner"></div>}
            {!hasOldMessages && !isLoadingOldMessages && noMoreOldChats && (
              <button
                onClick={fetchOldMessages}
                className="load-old-messages-button"
              >
                Load Older Messages
              </button>
            )}

            {unseenCount > 0 && (
              <div
                className="new-message-notification"
                onClick={goToNewMessages}
              >
                New Messages <FaAngleDoubleDown />
              </div>
            )}

{messages
  .slice()
  .reverse()
  .map((message, index) => (
    <React.Fragment key={index}>
      {message.msgtype === "comment" ? (
        <div style={{ textAlign: "center" }}>
          <div
            className="comment-message"
            style={{ margin: "5px 0", color: "rgb(159 159 159)" }}
          >
            <p>{message.msg}</p>
            <small>{convertUtcToLocal(message.sent_at)}</small>
          </div>
        </div>
      ) : (
        <div
          className={`message-bubble ${
            message.type === "admin" && message.from === user?.pseudonym
              ? "admin-message-right" // Admin's own message aligned right
              : message.type === "admin" || message.msgtype === "auto-reply"
              ? "admin-message" // Admin and auto-reply messages aligned left
              : "client-message" // Visitor message aligned left
          }`}
        >
          <div className="chat-message-left">
            <span style={{ fontSize: "10px", color: "#888" }}>
              {message.msgtype === "auto-reply"
                ? "System"
                : message.type === "admin" && message.from === user?.pseudonym
                ? "You"
                : message.type === "admin"
                ? message.from
                : "Visitor"}
            </span>

            {message.msgtype === "file" ? (
              <MessageFile message={message} />
            ) : (
              <MessageWithLink message={message?.msg} />
            )}
            {message.is_seen === 1 && message.type === "admin" && (
              <span className="message-seen-tick">
                <FaCheckDouble size={10} color="#53bdeb" />
              </span>
            )}
          </div>
          <div className="chat-message-right">
            <span style={{ fontSize: "10px", color: "#888" }}>
              {convertUtcToLocal(message.sent_at)}
            </span>
          </div>
        </div>
      )}
    </React.Fragment>
  ))}


          {/* Display typing indicator */}

          </div>
        </div>
        {AdmintypingUsers && AdmintypingUsers.size > 0 && (
        <div className="admin-typing-indicator">
          {Array.from(AdmintypingUsers.entries()).map(([userId], index) => (
            <div key={index} className="typing-user">
              
              <span
                style={{ width: "100%", overflow: "auto",fontSize:'9px', color:"#6c6c6c" }}
                
              > {userId} is typing...</span>
            </div>
          ))}
        </div>
      )}
       <ResizableTypingArea typingUsers={typingUsers}/>
        <div className="panel-input-box chat-visitor-item-2 mt-2">
          <div style={{ placeContent: "flex-end", height: "100%" }}>
            <div>
            <div style={{ position: 'relative' }}>
      {/* Hidden span to calculate the cursor position */}
      <span
        ref={hiddenSpanRef}
        style={{
          visibility: 'hidden',
          whiteSpace: 'pre-wrap',
          position: 'absolute',
          top: 0,
          left: 0,
          fontSize: 'inherit',
          fontFamily: 'inherit',
          lineHeight: 'inherit',
          padding: '8px', // Match padding of textarea if necessary
        }}
      ></span>
  
      <textarea
        className="w-100 border-none message-box-textarea"
        style={{ resize: 'none', border: 'none', position: 'relative' }}
        rows={3}
        ref={textareaRef}
        value={newMessageRef.current}
        onChange={handleInputChange}
        onKeyDown={handleKeyDown}
        placeholder="Type your message..."
      />

{/* // Suggestion dropdown positioned based on cursor */}
{isSuggestionVisible && (
  <ul
    style={{
      position: 'absolute',
      backgroundColor: 'white',
      border: '1px solid #ccc',
      listStyleType: 'none',
      margin: 0,
      padding: '0.5rem',
      maxHeight: '150px',
      overflowY: 'auto',
      width: '200px',
      zIndex: 10,
      top: suggestionPosition.top,
      left: suggestionPosition.left,
    }}
  >
    {filteredSuggestions.map((suggestion, index) => (
    <li
      key={suggestion.id}
      style={{
        padding: '0.5rem',
        backgroundColor: index === selectedSuggestionIndex ? '#ddd' : 'white',
        cursor: 'pointer',
        wordBreak: 'break-word',
        whiteSpace: 'pre-wrap',
        color: 'black',
        display:'flex',
        justifyContent:"space-between",
        alignItems:'center'

      }}
      onMouseDown={() => selectSuggestion(suggestion)}
    >
      {suggestion.text}{' '}
      {suggestion.type === 'public' ? (
        <IoIosPeople size={18}  style={{ marginLeft: '0.5rem', color: 'rgb(27 92 215)' }} />
      ) : (
        <FaUserShield size={16} style={{ marginLeft: '0.5rem', color: 'green' }} />
      )}
    </li>
  ))}
  </ul>
)}
    </div>
            </div>
            <div
              className="d-flex chat-bottom-area p-2 border align align-items-center"
              style={{ fontSize: "11px" }}
            >
              <span style={{ flex: 3, color: "black",fontSize:'10px' }}>
                Type and press Enter
              </span>
              <div
                style={{ flex: 3, cursor: "pointer" }}
                className="d-flex justify-content-end"
              >
              
                {/* Button to show emoji picker */}
                <span
                  className="px-2 chat-extra-btns  emoji-btn"
                  onClick={() => setShowPicker(!showPicker)}
                >
                  <HiEmojiHappy
                    style={{ marginRight: "1px", fontSize: "15px" }}
                  />
                  <span>Emoji</span>
                </span>

                {/* Emoji picker dropdown */}
                {showPicker && (
                  <div className="emoji-picker-container" ref={pickerRef}>
                    <EmojiPicker
                      width={250}
                      height={300}
                      searchDisabled
                      size={12}
                      lazyLoadEmojis={true}
                      style={{ fontSize: "11px" }}
                      previewConfig={{
                        showPreview: false,
                      }}
                      onEmojiClick={onEmojiClick}
                      pickerStyle={{ position: "absolute", zIndex: 1000 }}
                    />
                  </div>
                )}
                {/* Conditionally render based on rating state */}
                <span
                  className={`px-2 chat-extra-btns ${
                    chatRating === 3 ? "no-rating-given" : ""
                  }`}
                >
                  {chatRating === 1 && (
                    <>
                      <AiFillLike
                        style={{
                          marginRight: "1px",
                          fontSize: "15px",
                          color: "green",
                        }}
                      />
                      <span style={{ color: "green" }}>Rating</span>
                    </>
                  )}

                  {chatRating === 0 && (
                    <>
                      <AiFillDislike
                        style={{
                          marginRight: "1px",
                          fontSize: "15px",
                          color: "red",
                        }}
                      />
                      <span style={{ color: "red" }}>Rating</span>
                    </>
                  )}

                  {chatRating === 3 && (
                    <>
                      <AiOutlineLike
                        style={{ marginRight: "1px", fontSize: "15px" }}
                      />
                      <span>Rating</span>
                    </>
                  )}
                </span>

                {/* Button to open file input */}
                <span
                  className="px-2 chat-extra-btns"
                  onClick={() => document.getElementById("fileInput").click()}
                >
                  <IoIosAttach
                    style={{ marginRight: "1px", fontSize: "15px" }}
                  />
                  <span>Attach</span>
                </span>

                {/* Hidden file input for selecting image files */}
                <input
                  type="file"
                  id="fileInput"
                  accept=".jpg,.jpeg,.png"
                  style={{ display: "none" }}
                  onChange={handleFileChange}
                />

                {/* Show a preview of the selected file (if any) */}
                {file && (
                  <div className="file-preview">
                    <p>Selected file: {file.name}</p>
                    <button onClick={handleFileUpload}>Send File</button>
                  </div>
                )}
              </div>
            </div>
          </div>
        </div>
      </div>
 
      <VisitorMeta
        clientId={currentChat.client_id}
        publicKey={currentChat.public_key}
        currentChat={currentChat}
        visitorRef={visitorRef}
        fetchChatHistory={fetchChatHistory}
        user={user}
      />
    </div>
    </>
  );
};

export default GlobalChat;
